/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class FluxFirstNonEmptyEmitting<T>
extends Flux<T>
implements Scannable,
Publisher<T> {
    final Publisher<? extends T>[] array;
    final Iterable<? extends Publisher<? extends T>> iterable;

    @SafeVarargs
    FluxFirstNonEmptyEmitting(Publisher<? extends T> ... array) {
        this.array = Objects.requireNonNull(array, "array");
        this.iterable = null;
    }

    FluxFirstNonEmptyEmitting(Iterable<? extends Publisher<? extends T>> iterable) {
        this.array = null;
        this.iterable = Objects.requireNonNull(iterable);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        int n;
        Publisher<? extends T>[] a;
        block13: {
            a = this.array;
            if (a == null) {
                Iterator<Publisher<T>> it;
                n = 0;
                a = new Publisher[8];
                try {
                    it = Objects.requireNonNull(this.iterable.iterator(), "The iterator returned is null");
                }
                catch (Throwable e) {
                    Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
                    return;
                }
                while (true) {
                    Publisher<? extends T> p;
                    boolean b;
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e) {
                        Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
                        return;
                    }
                    if (!b) break block13;
                    try {
                        p = Objects.requireNonNull(it.next(), "The Publisher returned by the iterator is null");
                    }
                    catch (Throwable e) {
                        Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
                        return;
                    }
                    if (n == a.length) {
                        Publisher[] c = new Publisher[n + (n >> 2)];
                        System.arraycopy(a, 0, c, 0, n);
                        a = c;
                    }
                    a[n++] = p;
                }
            }
            n = a.length;
        }
        if (n == 0) {
            Operators.complete(actual);
            return;
        }
        if (n == 1) {
            Publisher<T> p = a[0];
            if (p == null) {
                Operators.error(actual, new NullPointerException("The single source Publisher is null"));
            } else {
                p.subscribe(actual);
            }
            return;
        }
        RaceCoordinator<? extends T> coordinator = new RaceCoordinator<T>(n);
        coordinator.subscribe(a, n, actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }

    @Override
    public String stepName() {
        return "source(" + this.getClass().getSimpleName() + ")";
    }

    static final class RaceCoordinator<T>
    implements Subscription,
    Scannable {
        final FirstNonEmptyEmittingSubscriber<T>[] subscribers;
        volatile boolean cancelled;
        volatile int wip;
        volatile int competingSubscribers;
        static final AtomicIntegerFieldUpdater<RaceCoordinator> WIP = AtomicIntegerFieldUpdater.newUpdater(RaceCoordinator.class, "wip");
        static final AtomicIntegerFieldUpdater<RaceCoordinator> COMPETING_SUBSCRIBERS = AtomicIntegerFieldUpdater.newUpdater(RaceCoordinator.class, "competingSubscribers");

        RaceCoordinator(int n) {
            this.subscribers = new FirstNonEmptyEmittingSubscriber[n];
            this.wip = Integer.MIN_VALUE;
            this.competingSubscribers = n;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.subscribers);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            return null;
        }

        void subscribe(Publisher<? extends T>[] sources, int n, CoreSubscriber<? super T> actual) {
            int i2;
            FirstNonEmptyEmittingSubscriber<T>[] a = this.subscribers;
            for (i2 = 0; i2 < n; ++i2) {
                a[i2] = new FirstNonEmptyEmittingSubscriber<T>(actual, this, i2);
            }
            actual.onSubscribe(this);
            for (i2 = 0; i2 < n; ++i2) {
                if (this.cancelled || this.wip != Integer.MIN_VALUE) {
                    return;
                }
                Publisher<T> p = sources[i2];
                if (p == null) {
                    if (WIP.compareAndSet(this, Integer.MIN_VALUE, -1)) {
                        actual.onError(new NullPointerException("The " + i2 + " th Publisher source is null"));
                    }
                    return;
                }
                p.subscribe(a[i2]);
            }
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                int w = this.wip;
                if (w >= 0) {
                    this.subscribers[w].request(n);
                } else {
                    for (FirstNonEmptyEmittingSubscriber<T> s : this.subscribers) {
                        s.request(n);
                    }
                }
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            int w = this.wip;
            if (w >= 0) {
                this.subscribers[w].cancel();
            } else {
                for (FirstNonEmptyEmittingSubscriber<T> s : this.subscribers) {
                    s.cancel();
                }
            }
        }

        boolean tryWin(int index) {
            if (this.wip == Integer.MIN_VALUE && WIP.compareAndSet(this, Integer.MIN_VALUE, index)) {
                FirstNonEmptyEmittingSubscriber<T>[] a = this.subscribers;
                int n = a.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (i2 == index) continue;
                    a[i2].cancel();
                }
                return true;
            }
            return false;
        }

        int resignFromRace() {
            return COMPETING_SUBSCRIBERS.decrementAndGet(this);
        }
    }

    static final class FirstNonEmptyEmittingSubscriber<T>
    extends Operators.DeferredSubscription
    implements CoreSubscriber<T>,
    Scannable,
    Subscription {
        final RaceCoordinator<T> parent;
        final CoreSubscriber<? super T> actual;
        final int index;
        boolean won;

        FirstNonEmptyEmittingSubscriber(CoreSubscriber<? super T> actual, RaceCoordinator<T> parent, int index) {
            this.actual = actual;
            this.parent = parent;
            this.index = index;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.parent.cancelled;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.set(s);
        }

        @Override
        public void onNext(T t) {
            if (this.won) {
                this.actual.onNext(t);
            } else if (this.parent.tryWin(this.index)) {
                this.won = true;
                this.actual.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.won) {
                this.actual.onError(t);
            } else if (this.parent.tryWin(this.index)) {
                this.won = true;
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.won || this.parent.resignFromRace() == 0) {
                this.actual.onComplete();
            }
        }

        @Override
        public String stepName() {
            return "CloudFlux.firstNonEmpty";
        }
    }
}

