/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;

public class ClientHttpResponseStatusCodeException
extends RetryableStatusCodeException {
    private final ClientHttpResponseWrapper response;

    public ClientHttpResponseStatusCodeException(String serviceId, ClientHttpResponse response, byte[] body2) throws IOException {
        super(serviceId, response.getStatusCode().value(), response, null);
        this.response = new ClientHttpResponseWrapper(response, body2);
    }

    @Override
    public ClientHttpResponse getResponse() {
        return this.response;
    }

    static class ClientHttpResponseWrapper
    extends AbstractClientHttpResponse {
        private ClientHttpResponse response;
        private byte[] body;

        ClientHttpResponseWrapper(ClientHttpResponse response, byte[] body2) {
            this.response = response;
            this.body = body2;
        }

        @Override
        public int getRawStatusCode() throws IOException {
            return this.response.getStatusCode().value();
        }

        @Override
        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        @Override
        public void close() {
            this.response.close();
        }

        @Override
        public InputStream getBody() {
            return new ByteArrayInputStream(this.body);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }
    }
}

