/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.observation;

import io.micrometer.common.KeyValues;
import java.util.Locale;
import org.springframework.cloud.client.circuitbreaker.observation.CircuitBreakerObservationContext;
import org.springframework.cloud.client.circuitbreaker.observation.CircuitBreakerObservationConvention;
import org.springframework.cloud.client.circuitbreaker.observation.CircuitBreakerObservationDocumentation;

public class DefaultCircuitBreakerObservationConvention
implements CircuitBreakerObservationConvention {
    public static final DefaultCircuitBreakerObservationConvention INSTANCE = new DefaultCircuitBreakerObservationConvention();

    @Override
    public KeyValues getLowCardinalityKeyValues(CircuitBreakerObservationContext context) {
        return KeyValues.of(CircuitBreakerObservationDocumentation.LowCardinalityTags.OBJECT_TYPE.withValue(context.getType().name().toLowerCase(Locale.ROOT)));
    }

    @Override
    public String getName() {
        return "spring.cloud.circuitbreaker";
    }

    @Override
    public String getContextualName(CircuitBreakerObservationContext context) {
        if (context.getType() == CircuitBreakerObservationContext.Type.SUPPLIER) {
            return "circuit-breaker";
        }
        return "circuit-breaker fallback";
    }
}

