/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.actuator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.actuator.NamedFeature;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Endpoint(id="features")
public class FeaturesEndpoint
implements ApplicationContextAware {
    private final List<HasFeatures> hasFeaturesList;
    private ApplicationContext context;

    public FeaturesEndpoint(List<HasFeatures> hasFeaturesList) {
        this.hasFeaturesList = hasFeaturesList;
    }

    @Override
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    @ReadOperation
    public Features features() {
        Features features = new Features();
        for (HasFeatures hasFeatures : this.hasFeaturesList) {
            List<NamedFeature> namedFeatures;
            List<Class<?>> abstractFeatures = hasFeatures.getAbstractFeatures();
            if (abstractFeatures != null) {
                for (Class<?> clazz : abstractFeatures) {
                    this.addAbstractFeature(features, clazz);
                }
            }
            if ((namedFeatures = hasFeatures.getNamedFeatures()) == null) continue;
            for (NamedFeature namedFeature : namedFeatures) {
                this.addFeature(features, namedFeature);
            }
        }
        return features;
    }

    private void addAbstractFeature(Features features, Class<?> type) {
        String featureName = type.getSimpleName();
        try {
            Object bean2 = this.context.getBean(type);
            Class<?> beanClass = bean2.getClass();
            this.addFeature(features, new NamedFeature(featureName, beanClass));
        }
        catch (NoSuchBeanDefinitionException e) {
            features.getDisabled().add(featureName);
        }
    }

    private void addFeature(Features features, NamedFeature feature) {
        Class<?> type = feature.getType();
        features.getEnabled().add(new Feature(feature.getName(), type.getCanonicalName(), type.getPackage().getImplementationVersion(), type.getPackage().getImplementationVendor()));
    }

    static class Features {
        final List<Feature> enabled = new ArrayList<Feature>();
        final List<String> disabled = new ArrayList<String>();

        Features() {
        }

        public List<Feature> getEnabled() {
            return this.enabled;
        }

        public List<String> getDisabled() {
            return this.disabled;
        }
    }

    static class Feature {
        final String type;
        final String name;
        final String version;
        final String vendor;

        Feature(String name, String type, String version, String vendor) {
            this.type = type;
            this.name = name;
            this.version = version;
            this.vendor = vendor;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String toString() {
            return "Feature{type='" + this.type + "', name='" + this.name + "', version='" + this.version + "', vendor='" + this.vendor + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Feature feature = (Feature)o;
            if (!Objects.equals(this.type, feature.type)) {
                return false;
            }
            if (!Objects.equals(this.name, feature.name)) {
                return false;
            }
            if (!Objects.equals(this.version, feature.version)) {
                return false;
            }
            return Objects.equals(this.vendor, feature.vendor);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.vendor != null ? this.vendor.hashCode() : 0);
            return result;
        }
    }
}

