/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredOperationMethod;
import org.springframework.boot.actuate.endpoint.annotation.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.annotation.DiscoveredServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointFilter;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.MergedAnnotations;

@ImportRuntimeHints(value={ServletEndpointDiscovererRuntimeHints.class})
public class ServletEndpointDiscoverer
extends EndpointDiscoverer<ExposableServletEndpoint, Operation>
implements ServletEndpointsSupplier {
    private final List<PathMapper> endpointPathMappers;

    public ServletEndpointDiscoverer(ApplicationContext applicationContext, List<PathMapper> endpointPathMappers, Collection<EndpointFilter<ExposableServletEndpoint>> filters) {
        super(applicationContext, ParameterValueMapper.NONE, Collections.emptyList(), filters);
        this.endpointPathMappers = endpointPathMappers;
    }

    @Override
    protected boolean isEndpointTypeExposed(Class<?> beanType) {
        return MergedAnnotations.from(beanType, MergedAnnotations.SearchStrategy.SUPERCLASS).isPresent(ServletEndpoint.class);
    }

    @Override
    protected ExposableServletEndpoint createEndpoint(Object endpointBean, EndpointId id, boolean enabledByDefault, Collection<Operation> operations) {
        String rootPath = PathMapper.getRootPath(this.endpointPathMappers, id);
        return new DiscoveredServletEndpoint(this, endpointBean, id, rootPath, enabledByDefault);
    }

    @Override
    protected Operation createOperation(EndpointId endpointId, DiscoveredOperationMethod operationMethod, OperationInvoker invoker) {
        throw new IllegalStateException("ServletEndpoints must not declare operations");
    }

    @Override
    protected EndpointDiscoverer.OperationKey createOperationKey(Operation operation) {
        throw new IllegalStateException("ServletEndpoints must not declare operations");
    }

    static class ServletEndpointDiscovererRuntimeHints
    implements RuntimeHintsRegistrar {
        ServletEndpointDiscovererRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(ServletEndpointFilter.class, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        }
    }
}

