/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.data.redis;

import java.util.Properties;
import org.springframework.boot.actuate.data.redis.RedisHealth;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RedisReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveRedisConnectionFactory connectionFactory;

    public RedisReactiveHealthIndicator(ReactiveRedisConnectionFactory connectionFactory) {
        super("Redis health check failed");
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.getConnection().flatMap(connection -> this.doHealthCheck(builder, (ReactiveRedisConnection)connection));
    }

    private Mono<ReactiveRedisConnection> getConnection() {
        return Mono.fromSupplier(() -> ((ReactiveRedisConnectionFactory)this.connectionFactory).getReactiveConnection()).subscribeOn(Schedulers.boundedElastic());
    }

    private Mono<Health> doHealthCheck(Health.Builder builder, ReactiveRedisConnection connection) {
        return this.getHealth(builder, connection).onErrorResume(ex -> Mono.just(builder.down((Throwable)ex).build())).flatMap(health -> connection.closeLater().thenReturn(health));
    }

    private Mono<Health> getHealth(Health.Builder builder, ReactiveRedisConnection connection) {
        if (connection instanceof ReactiveRedisClusterConnection) {
            ReactiveRedisClusterConnection clusterConnection = (ReactiveRedisClusterConnection)connection;
            return clusterConnection.clusterGetClusterInfo().map(info -> this.fromClusterInfo(builder, (ClusterInfo)info));
        }
        return connection.serverCommands().info("server").map(info -> this.up(builder, (Properties)info));
    }

    private Health up(Health.Builder builder, Properties info) {
        return RedisHealth.up(builder, info).build();
    }

    private Health fromClusterInfo(Health.Builder builder, ClusterInfo clusterInfo) {
        return RedisHealth.fromClusterInfo(builder, clusterInfo).build();
    }
}

