/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing.zipkin;

import java.time.Duration;
import org.springframework.boot.actuate.autoconfigure.tracing.zipkin.HttpSender;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import zipkin2.Call;
import zipkin2.Callback;

class ZipkinWebClientSender
extends HttpSender {
    private final String endpoint;
    private final WebClient webClient;
    private final Duration timeout;

    ZipkinWebClientSender(String endpoint, WebClient webClient, Duration timeout) {
        this.endpoint = endpoint;
        this.webClient = webClient;
        this.timeout = timeout;
    }

    @Override
    public HttpSender.HttpPostCall sendSpans(byte[] batchedEncodedSpans) {
        return new WebClientHttpPostCall(this.endpoint, batchedEncodedSpans, this.webClient, this.timeout);
    }

    private static class WebClientHttpPostCall
    extends HttpSender.HttpPostCall {
        private final String endpoint;
        private final WebClient webClient;
        private final Duration timeout;

        WebClientHttpPostCall(String endpoint, byte[] body2, WebClient webClient, Duration timeout) {
            super(body2);
            this.endpoint = endpoint;
            this.webClient = webClient;
            this.timeout = timeout;
        }

        public Call<Void> clone() {
            return new WebClientHttpPostCall(this.endpoint, this.getUncompressedBody(), this.webClient, this.timeout);
        }

        protected Void doExecute() {
            this.sendRequest().block();
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            this.sendRequest().subscribe(entity -> callback.onSuccess(null), arg_0 -> callback.onError(arg_0));
        }

        private Mono<ResponseEntity<Void>> sendRequest() {
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.endpoint, new Object[0])).headers(this::addDefaultHeaders)).bodyValue(this.getBody()).retrieve().toBodilessEntity().timeout(this.timeout);
        }

        private void addDefaultHeaders(HttpHeaders headers) {
            headers.addAll(this.getDefaultHeaders());
        }
    }
}

