/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.system;

import java.io.File;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="management.health.diskspace")
public class DiskSpaceHealthIndicatorProperties {
    private File path = new File(".");
    private DataSize threshold = DataSize.ofMegabytes(10L);

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public DataSize getThreshold() {
        return this.threshold;
    }

    public void setThreshold(DataSize threshold) {
        Assert.isTrue(!threshold.isNegative(), "threshold must be greater than or equal to 0");
        this.threshold = threshold;
    }
}

