/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation.web.client;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationProperties;
import org.springframework.boot.actuate.metrics.web.reactive.client.ObservationWebClientCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.DefaultClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
class WebClientObservationConfiguration {
    WebClientObservationConfiguration() {
    }

    @Bean
    ObservationWebClientCustomizer observationWebClientCustomizer(ObservationRegistry observationRegistry, ObjectProvider<ClientRequestObservationConvention> customConvention, ObservationProperties observationProperties, MetricsProperties metricsProperties) {
        String name = observationProperties.getHttp().getClient().getRequests().getName();
        ClientRequestObservationConvention observationConvention = customConvention.getIfAvailable(() -> new DefaultClientRequestObservationConvention(name));
        return new ObservationWebClientCustomizer(observationRegistry, observationConvention);
    }
}

