/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.convert.DurationStyle;

public final class MeterValue {
    private final Object value;

    MeterValue(double value) {
        this.value = value;
    }

    MeterValue(Duration value) {
        this.value = value;
    }

    public Double getValue(Meter.Type meterType) {
        Long timerValue;
        if (meterType == Meter.Type.DISTRIBUTION_SUMMARY) {
            return this.getDistributionSummaryValue();
        }
        if (meterType == Meter.Type.TIMER && (timerValue = this.getTimerValue()) != null) {
            return timerValue.doubleValue();
        }
        return null;
    }

    private Double getDistributionSummaryValue() {
        Object object = this.value;
        if (object instanceof Double) {
            Double doubleValue = (Double)object;
            return doubleValue;
        }
        return null;
    }

    private Long getTimerValue() {
        Object object = this.value;
        if (object instanceof Double) {
            Double doubleValue = (Double)object;
            return TimeUnit.MILLISECONDS.toNanos(doubleValue.longValue());
        }
        object = this.value;
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return duration.toNanos();
        }
        return null;
    }

    public static MeterValue valueOf(String value) {
        Duration duration = MeterValue.safeParseDuration(value);
        if (duration != null) {
            return new MeterValue(duration);
        }
        return new MeterValue(Double.valueOf(value));
    }

    public static MeterValue valueOf(double value) {
        return new MeterValue(value);
    }

    private static Duration safeParseDuration(String value) {
        try {
            return DurationStyle.detectAndParse(value);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

