/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynamic;

import java.util.Locale;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class DynamicPointerFactory
implements NodePointerFactory {
    public static final int DYNAMIC_POINTER_FACTORY_ORDER = 800;

    public int getOrder() {
        return 800;
    }

    public NodePointer createNodePointer(QName name, Object bean2, Locale locale) {
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean2.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = ValueUtils.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPointer(name, bean2, handler, locale);
        }
        return null;
    }

    public NodePointer createNodePointer(NodePointer parent, QName name, Object bean2) {
        if (bean2 == null) {
            return new NullPointer(parent, name);
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean2.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = ValueUtils.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPointer(parent, name, bean2, handler);
        }
        return null;
    }
}

