/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry.rule;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.rule.AlwaysMatchInstanceStatusRule;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.StatusOverrideResult;
import java.util.ArrayList;

public class FirstMatchWinsCompositeRule
implements InstanceStatusOverrideRule {
    private final InstanceStatusOverrideRule[] rules;
    private final InstanceStatusOverrideRule defaultRule;
    private final String compositeRuleName;

    public FirstMatchWinsCompositeRule(InstanceStatusOverrideRule ... rules) {
        this.rules = rules;
        this.defaultRule = new AlwaysMatchInstanceStatusRule();
        ArrayList<String> ruleNames = new ArrayList<String>(rules.length + 1);
        for (int i2 = 0; i2 < rules.length; ++i2) {
            ruleNames.add(rules[i2].toString());
        }
        ruleNames.add(this.defaultRule.toString());
        this.compositeRuleName = ((Object)ruleNames).toString();
    }

    @Override
    public StatusOverrideResult apply(InstanceInfo instanceInfo, Lease<InstanceInfo> existingLease, boolean isReplication) {
        for (int i2 = 0; i2 < this.rules.length; ++i2) {
            StatusOverrideResult result = this.rules[i2].apply(instanceInfo, existingLease, isReplication);
            if (!result.matches()) continue;
            return result;
        }
        return this.defaultRule.apply(instanceInfo, existingLease, isReplication);
    }

    public String toString() {
        return this.compositeRuleName;
    }
}

