/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.AbstractInstanceRegistry;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.registry.ResponseCache;
import com.netflix.eureka.resources.CurrentRequestVersion;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCacheImpl
implements ResponseCache {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCacheImpl.class);
    public static final String ALL_APPS = "ALL_APPS";
    public static final String ALL_APPS_DELTA = "ALL_APPS_DELTA";
    private static final AtomicLong versionDeltaLegacy = new AtomicLong(0L);
    private static final AtomicLong versionDeltaWithRegionsLegacy = new AtomicLong(0L);
    private static final String EMPTY_PAYLOAD = "";
    private final java.util.Timer timer = new java.util.Timer("Eureka-CacheFillTimer", true);
    private final AtomicLong versionDelta = new AtomicLong(0L);
    private final AtomicLong versionDeltaWithRegions = new AtomicLong(0L);
    private final Timer serializeAllAppsTimer = Monitors.newTimer("serialize-all");
    private final Timer serializeDeltaAppsTimer = Monitors.newTimer("serialize-all-delta");
    private final Timer serializeAllAppsWithRemoteRegionTimer = Monitors.newTimer("serialize-all_remote_region");
    private final Timer serializeDeltaAppsWithRemoteRegionTimer = Monitors.newTimer("serialize-all-delta_remote_region");
    private final Timer serializeOneApptimer = Monitors.newTimer("serialize-one");
    private final Timer serializeViptimer = Monitors.newTimer("serialize-one-vip");
    private final Timer compressPayloadTimer = Monitors.newTimer("compress-payload");
    private final Multimap<Key, Key> regionSpecificKeys = Multimaps.newListMultimap(new ConcurrentHashMap(), new Supplier<List<Key>>(){

        @Override
        public List<Key> get() {
            return new CopyOnWriteArrayList<Key>();
        }
    });
    private final ConcurrentMap<Key, Value> readOnlyCacheMap = new ConcurrentHashMap<Key, Value>();
    private final LoadingCache<Key, Value> readWriteCacheMap;
    private final boolean shouldUseReadOnlyResponseCache;
    private final AbstractInstanceRegistry registry;
    private final EurekaServerConfig serverConfig;
    private final ServerCodecs serverCodecs;

    ResponseCacheImpl(EurekaServerConfig serverConfig, ServerCodecs serverCodecs, AbstractInstanceRegistry registry) {
        this.serverConfig = serverConfig;
        this.serverCodecs = serverCodecs;
        this.shouldUseReadOnlyResponseCache = serverConfig.shouldUseReadOnlyResponseCache();
        this.registry = registry;
        long responseCacheUpdateIntervalMs = serverConfig.getResponseCacheUpdateIntervalMs();
        this.readWriteCacheMap = CacheBuilder.newBuilder().initialCapacity(serverConfig.getInitialCapacityOfResponseCache()).expireAfterWrite(serverConfig.getResponseCacheAutoExpirationInSeconds(), TimeUnit.SECONDS).removalListener(new RemovalListener<Key, Value>(){

            @Override
            public void onRemoval(RemovalNotification<Key, Value> notification) {
                Key removedKey = notification.getKey();
                if (removedKey.hasRegions()) {
                    Key cloneWithNoRegions = removedKey.cloneWithoutRegions();
                    ResponseCacheImpl.this.regionSpecificKeys.remove(cloneWithNoRegions, removedKey);
                }
            }
        }).build(new CacheLoader<Key, Value>(){

            @Override
            public Value load(Key key) throws Exception {
                if (key.hasRegions()) {
                    Key cloneWithNoRegions = key.cloneWithoutRegions();
                    ResponseCacheImpl.this.regionSpecificKeys.put(cloneWithNoRegions, key);
                }
                Value value = ResponseCacheImpl.this.generatePayload(key);
                return value;
            }
        });
        if (this.shouldUseReadOnlyResponseCache) {
            this.timer.schedule(this.getCacheUpdateTask(), new Date(System.currentTimeMillis() / responseCacheUpdateIntervalMs * responseCacheUpdateIntervalMs + responseCacheUpdateIntervalMs), responseCacheUpdateIntervalMs);
        }
        try {
            Monitors.registerObject(this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry", e);
        }
    }

    private TimerTask getCacheUpdateTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug("Updating the client cache from response cache");
                for (Key key : ResponseCacheImpl.this.readOnlyCacheMap.keySet()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Updating the client cache from response cache for key : {} {} {} {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType()});
                    }
                    try {
                        Value currentCacheValue;
                        CurrentRequestVersion.set(key.getVersion());
                        Value cacheValue = (Value)ResponseCacheImpl.this.readWriteCacheMap.get(key);
                        if (cacheValue == (currentCacheValue = (Value)ResponseCacheImpl.this.readOnlyCacheMap.get(key))) continue;
                        ResponseCacheImpl.this.readOnlyCacheMap.put(key, cacheValue);
                    }
                    catch (Throwable th) {
                        logger.error("Error while updating the client cache from response cache for key {}", (Object)key.toStringCompact(), (Object)th);
                    }
                    finally {
                        CurrentRequestVersion.remove();
                    }
                }
            }
        };
    }

    @Override
    public String get(Key key) {
        return this.get(key, this.shouldUseReadOnlyResponseCache);
    }

    @VisibleForTesting
    String get(Key key, boolean useReadOnlyCache) {
        Value payload = this.getValue(key, useReadOnlyCache);
        if (payload == null || payload.getPayload().equals(EMPTY_PAYLOAD)) {
            return null;
        }
        return payload.getPayload();
    }

    @Override
    public byte[] getGZIP(Key key) {
        Value payload = this.getValue(key, this.shouldUseReadOnlyResponseCache);
        if (payload == null) {
            return null;
        }
        return payload.getGzipped();
    }

    @Override
    public void stop() {
        this.timer.cancel();
        Monitors.unregisterObject(this);
    }

    @Override
    public void invalidate(String appName, @Nullable String vipAddress, @Nullable String secureVipAddress) {
        for (Key.KeyType type : Key.KeyType.values()) {
            for (Version v : Version.values()) {
                this.invalidate(new Key(Key.EntityType.Application, appName, type, v, EurekaAccept.full), new Key(Key.EntityType.Application, appName, type, v, EurekaAccept.compact), new Key(Key.EntityType.Application, ALL_APPS, type, v, EurekaAccept.full), new Key(Key.EntityType.Application, ALL_APPS, type, v, EurekaAccept.compact), new Key(Key.EntityType.Application, ALL_APPS_DELTA, type, v, EurekaAccept.full), new Key(Key.EntityType.Application, ALL_APPS_DELTA, type, v, EurekaAccept.compact));
                if (null != vipAddress) {
                    this.invalidate(new Key(Key.EntityType.VIP, vipAddress, type, v, EurekaAccept.full));
                }
                if (null == secureVipAddress) continue;
                this.invalidate(new Key(Key.EntityType.SVIP, secureVipAddress, type, v, EurekaAccept.full));
            }
        }
    }

    public void invalidate(Key ... keys) {
        for (Key key : keys) {
            logger.debug("Invalidating the response cache key : {} {} {} {}, {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType(), key.getEurekaAccept()});
            this.readWriteCacheMap.invalidate(key);
            Collection<Key> keysWithRegions = this.regionSpecificKeys.get(key);
            if (null == keysWithRegions || keysWithRegions.isEmpty()) continue;
            for (Key keysWithRegion : keysWithRegions) {
                logger.debug("Invalidating the response cache key : {} {} {} {} {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType(), key.getEurekaAccept()});
                this.readWriteCacheMap.invalidate(keysWithRegion);
            }
        }
    }

    @Override
    public AtomicLong getVersionDelta() {
        return this.versionDelta;
    }

    @Override
    public AtomicLong getVersionDeltaWithRegions() {
        return this.versionDeltaWithRegions;
    }

    @Deprecated
    public static AtomicLong getVersionDeltaStatic() {
        return versionDeltaLegacy;
    }

    @Deprecated
    public static AtomicLong getVersionDeltaWithRegionsLegacy() {
        return versionDeltaWithRegionsLegacy;
    }

    @Monitor(name="responseCacheSize", type=DataSourceType.GAUGE)
    public int getCurrentSize() {
        return this.readWriteCacheMap.asMap().size();
    }

    @VisibleForTesting
    Value getValue(Key key, boolean useReadOnlyCache) {
        Value payload = null;
        try {
            if (useReadOnlyCache) {
                Value currentPayload = (Value)this.readOnlyCacheMap.get(key);
                if (currentPayload != null) {
                    payload = currentPayload;
                } else {
                    payload = this.readWriteCacheMap.get(key);
                    this.readOnlyCacheMap.put(key, payload);
                }
            } else {
                payload = this.readWriteCacheMap.get(key);
            }
        }
        catch (Throwable t) {
            logger.error("Cannot get value for key : {}", (Object)key, (Object)t);
        }
        return payload;
    }

    private String getPayLoad(Key key, Applications apps) {
        String result;
        EncoderWrapper encoderWrapper = this.serverCodecs.getEncoder(key.getType(), key.getEurekaAccept());
        try {
            result = encoderWrapper.encode(apps);
        }
        catch (Exception e) {
            logger.error("Failed to encode the payload for all apps", e);
            return EMPTY_PAYLOAD;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("New application cache entry {} with apps hashcode {}", (Object)key.toStringCompact(), (Object)apps.getAppsHashCode());
        }
        return result;
    }

    private String getPayLoad(Key key, Application app) {
        if (app == null) {
            return EMPTY_PAYLOAD;
        }
        EncoderWrapper encoderWrapper = this.serverCodecs.getEncoder(key.getType(), key.getEurekaAccept());
        try {
            return encoderWrapper.encode(app);
        }
        catch (Exception e) {
            logger.error("Failed to encode the payload for application {}", (Object)app.getName(), (Object)e);
            return EMPTY_PAYLOAD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value generatePayload(Key key) {
        Stopwatch tracer = null;
        try {
            String payload;
            switch (key.getEntityType()) {
                case Application: {
                    boolean isRemoteRegionRequested = key.hasRegions();
                    if (ALL_APPS.equals(key.getName())) {
                        if (isRemoteRegionRequested) {
                            tracer = this.serializeAllAppsWithRemoteRegionTimer.start();
                            payload = this.getPayLoad(key, this.registry.getApplicationsFromMultipleRegions(key.getRegions()));
                            break;
                        }
                        tracer = this.serializeAllAppsTimer.start();
                        payload = this.getPayLoad(key, this.registry.getApplications());
                        break;
                    }
                    if (ALL_APPS_DELTA.equals(key.getName())) {
                        if (isRemoteRegionRequested) {
                            tracer = this.serializeDeltaAppsWithRemoteRegionTimer.start();
                            this.versionDeltaWithRegions.incrementAndGet();
                            versionDeltaWithRegionsLegacy.incrementAndGet();
                            payload = this.getPayLoad(key, this.registry.getApplicationDeltasFromMultipleRegions(key.getRegions()));
                            break;
                        }
                        tracer = this.serializeDeltaAppsTimer.start();
                        this.versionDelta.incrementAndGet();
                        versionDeltaLegacy.incrementAndGet();
                        payload = this.getPayLoad(key, this.registry.getApplicationDeltas());
                        break;
                    }
                    tracer = this.serializeOneApptimer.start();
                    payload = this.getPayLoad(key, this.registry.getApplication(key.getName()));
                    break;
                }
                case VIP: 
                case SVIP: {
                    tracer = this.serializeViptimer.start();
                    payload = this.getPayLoad(key, ResponseCacheImpl.getApplicationsForVip(key, this.registry));
                    break;
                }
                default: {
                    logger.error("Unidentified entity type: {} found in the cache key.", (Object)key.getEntityType());
                    payload = EMPTY_PAYLOAD;
                }
            }
            Value value = new Value(payload);
            return value;
        }
        finally {
            if (tracer != null) {
                tracer.stop();
            }
        }
    }

    private static Applications getApplicationsForVip(Key key, AbstractInstanceRegistry registry) {
        logger.debug("Retrieving applications from registry for key : {} {} {} {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType()});
        Applications toReturn = new Applications();
        Applications applications = registry.getApplications();
        for (Application application : applications.getRegisteredApplications()) {
            Application appToAdd = null;
            for (InstanceInfo instanceInfo : application.getInstances()) {
                String vipAddress;
                if (Key.EntityType.VIP.equals((Object)key.getEntityType())) {
                    vipAddress = instanceInfo.getVIPAddress();
                } else {
                    if (!Key.EntityType.SVIP.equals((Object)key.getEntityType())) continue;
                    vipAddress = instanceInfo.getSecureVipAddress();
                }
                if (null == vipAddress) continue;
                Object[] vipAddresses = vipAddress.split(",");
                Arrays.sort(vipAddresses);
                if (Arrays.binarySearch(vipAddresses, key.getName()) < 0) continue;
                if (null == appToAdd) {
                    appToAdd = new Application(application.getName());
                    toReturn.addApplication(appToAdd);
                }
                appToAdd.addInstance(instanceInfo);
            }
        }
        toReturn.setAppsHashCode(toReturn.getReconcileHashCode());
        logger.debug("Retrieved applications from registry for key : {} {} {} {}, reconcile hashcode: {}", new Object[]{key.getEntityType(), key.getName(), key.getVersion(), key.getType(), toReturn.getReconcileHashCode()});
        return toReturn;
    }

    public class Value {
        private final String payload;
        private byte[] gzipped;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value(String payload) {
            this.payload = payload;
            if (!ResponseCacheImpl.EMPTY_PAYLOAD.equals(payload)) {
                Stopwatch tracer = ResponseCacheImpl.this.compressPayloadTimer.start();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    GZIPOutputStream out = new GZIPOutputStream(bos);
                    byte[] rawBytes = payload.getBytes();
                    out.write(rawBytes);
                    out.finish();
                    out.close();
                    bos.close();
                    this.gzipped = bos.toByteArray();
                }
                catch (IOException e) {
                    this.gzipped = null;
                }
                finally {
                    if (tracer != null) {
                        tracer.stop();
                    }
                }
            } else {
                this.gzipped = null;
            }
        }

        public String getPayload() {
            return this.payload;
        }

        public byte[] getGzipped() {
            return this.gzipped;
        }
    }
}

