/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.TransportException;
import com.netflix.discovery.shared.transport.TransportUtils;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluator;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableEurekaHttpClient
extends EurekaHttpClientDecorator {
    private static final Logger logger = LoggerFactory.getLogger(RetryableEurekaHttpClient.class);
    public static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    private final String name;
    private final EurekaTransportConfig transportConfig;
    private final ClusterResolver clusterResolver;
    private final TransportClientFactory clientFactory;
    private final ServerStatusEvaluator serverStatusEvaluator;
    private final int numberOfRetries;
    private final AtomicReference<EurekaHttpClient> delegate = new AtomicReference();
    private final Set<EurekaEndpoint> quarantineSet = new ConcurrentSkipListSet<EurekaEndpoint>();

    public RetryableEurekaHttpClient(String name, EurekaTransportConfig transportConfig, ClusterResolver clusterResolver, TransportClientFactory clientFactory, ServerStatusEvaluator serverStatusEvaluator, int numberOfRetries) {
        this.name = name;
        this.transportConfig = transportConfig;
        this.clusterResolver = clusterResolver;
        this.clientFactory = clientFactory;
        this.serverStatusEvaluator = serverStatusEvaluator;
        this.numberOfRetries = numberOfRetries;
        Monitors.registerObject(name, this);
    }

    @Override
    public void shutdown() {
        TransportUtils.shutdown(this.delegate.get());
        if (Monitors.isObjectRegistered(this.name, this)) {
            Monitors.unregisterObject(this.name, this);
        }
    }

    @Override
    protected <R> EurekaHttpResponse<R> execute(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor) {
        List<EurekaEndpoint> candidateHosts = null;
        int endpointIdx = 0;
        for (int retry = 0; retry < this.numberOfRetries; ++retry) {
            EurekaHttpClient currentHttpClient = this.delegate.get();
            EurekaEndpoint currentEndpoint = null;
            if (currentHttpClient == null) {
                if (candidateHosts == null && (candidateHosts = this.getHostCandidates()).isEmpty()) {
                    throw new TransportException("There is no known eureka server; cluster server list is empty");
                }
                if (endpointIdx >= candidateHosts.size()) {
                    throw new TransportException("Cannot execute request on any known server");
                }
                currentEndpoint = candidateHosts.get(endpointIdx++);
                currentHttpClient = this.clientFactory.newClient(currentEndpoint);
            }
            try {
                EurekaHttpResponse<R> response = requestExecutor.execute(currentHttpClient);
                if (this.serverStatusEvaluator.accept(response.getStatusCode(), requestExecutor.getRequestType())) {
                    this.delegate.set(currentHttpClient);
                    if (retry > 0) {
                        logger.info("Request execution succeeded on retry #{}", (Object)retry);
                    }
                    return response;
                }
                logger.warn("Request execution failure with status code {}; retrying on another server if available", (Object)response.getStatusCode());
            }
            catch (Exception e) {
                logger.warn("Request execution failed with message: {}", (Object)e.getMessage());
            }
            this.delegate.compareAndSet(currentHttpClient, null);
            if (currentEndpoint == null) continue;
            this.quarantineSet.add(currentEndpoint);
        }
        throw new TransportException("Retry limit reached; giving up on completing the request");
    }

    public static EurekaHttpClientFactory createFactory(final String name, final EurekaTransportConfig transportConfig, final ClusterResolver<EurekaEndpoint> clusterResolver, final TransportClientFactory delegateFactory, final ServerStatusEvaluator serverStatusEvaluator) {
        return new EurekaHttpClientFactory(){

            @Override
            public EurekaHttpClient newClient() {
                return new RetryableEurekaHttpClient(name, transportConfig, clusterResolver, delegateFactory, serverStatusEvaluator, 3);
            }

            @Override
            public void shutdown() {
                delegateFactory.shutdown();
            }
        };
    }

    private List<EurekaEndpoint> getHostCandidates() {
        List<EurekaEndpoint> candidateHosts = this.clusterResolver.getClusterEndpoints();
        this.quarantineSet.retainAll(candidateHosts);
        int threshold = (int)((double)candidateHosts.size() * this.transportConfig.getRetryableClientQuarantineRefreshPercentage());
        if (threshold > candidateHosts.size()) {
            threshold = candidateHosts.size();
        }
        if (!this.quarantineSet.isEmpty()) {
            if (this.quarantineSet.size() >= threshold) {
                logger.debug("Clearing quarantined list of size {}", (Object)this.quarantineSet.size());
                this.quarantineSet.clear();
            } else {
                ArrayList<EurekaEndpoint> remainingHosts = new ArrayList<EurekaEndpoint>(candidateHosts.size());
                for (EurekaEndpoint endpoint : candidateHosts) {
                    if (this.quarantineSet.contains(endpoint)) continue;
                    remainingHosts.add(endpoint);
                }
                candidateHosts = remainingHosts;
            }
        }
        return candidateHosts;
    }

    @Monitor(name="eurekaClient.transport.quarantineSize", description="number of servers quarantined", type=DataSourceType.GAUGE)
    public long getQuarantineSetSize() {
        return this.quarantineSet.size();
    }
}

