/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMeters;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMeters;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.util.annotation.Nullable;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    static final MicrometerHttpClientMetricsRecorder INSTANCE = new MicrometerHttpClientMetricsRecorder();
    private final ConcurrentMap<MeterKey, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    private final ConcurrentMap<MeterKey, DistributionSummary> dataSentCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    private final ConcurrentMap<MeterKey, Counter> errorsCache = new ConcurrentHashMap<MeterKey, Counter>();

    private MicrometerHttpClientMetricsRecorder() {
        super("reactor.netty.http.client", "http");
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, method, status);
        Timer dataReceivedTime = MapUtils.computeIfAbsent(this.dataReceivedTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder(this.name() + ".data.received.time").tags(HttpClientMeters.DataReceivedTimeTags.REMOTE_ADDRESS.asString(), address, HttpClientMeters.DataReceivedTimeTags.URI.asString(), uri, HttpClientMeters.DataReceivedTimeTags.METHOD.asString(), method, HttpClientMeters.DataReceivedTimeTags.STATUS.asString(), status).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        String proxyAddr;
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, proxyAddr = Metrics.formatSocketAddress(proxyAddress), method, status);
        Timer dataReceivedTime = MapUtils.computeIfAbsent(this.dataReceivedTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder(this.name() + ".data.received.time").tags(HttpClientMeters.DataReceivedTimeTags.REMOTE_ADDRESS.asString(), address, HttpClientMeters.DataReceivedTimeTags.PROXY_ADDRESS.asString(), proxyAddr, HttpClientMeters.DataReceivedTimeTags.URI.asString(), uri, HttpClientMeters.DataReceivedTimeTags.METHOD.asString(), method, HttpClientMeters.DataReceivedTimeTags.STATUS.asString(), status).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, method, null);
        Timer dataSentTime = MapUtils.computeIfAbsent(this.dataSentTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder(this.name() + ".data.sent.time").tags(HttpClientMeters.DataSentTimeTags.REMOTE_ADDRESS.asString(), address, HttpClientMeters.DataSentTimeTags.URI.asString(), uri, HttpClientMeters.DataSentTimeTags.METHOD.asString(), method).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, Duration time) {
        String proxyAddr;
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, proxyAddr = Metrics.formatSocketAddress(proxyAddress), method, null);
        Timer dataSentTime = MapUtils.computeIfAbsent(this.dataSentTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder(this.name() + ".data.sent.time").tags(HttpClientMeters.DataSentTimeTags.REMOTE_ADDRESS.asString(), address, HttpClientMeters.DataSentTimeTags.PROXY_ADDRESS.asString(), proxyAddr, HttpClientMeters.DataSentTimeTags.URI.asString(), uri, HttpClientMeters.DataSentTimeTags.METHOD.asString(), method).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer responseTime = this.getResponseTimeTimer(this.name() + ".response.time", address, uri, method, status);
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Nullable
    final Timer getResponseTimeTimer(String name, String address, String uri, String method, String status) {
        MeterKey meterKey = new MeterKey(uri, address, null, method, status);
        return MapUtils.computeIfAbsent(this.responseTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder(name).tags("remote.address", address, "uri", uri, "method", method, "status", status).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, String method, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        String proxyAddr = Metrics.formatSocketAddress(proxyAddress);
        Timer responseTime = this.getResponseTimeTimer(this.name() + ".response.time", address, proxyAddr, uri, method, status);
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Nullable
    final Timer getResponseTimeTimer(String name, String address, String proxyAddress, String uri, String method, String status) {
        MeterKey meterKey = new MeterKey(uri, address, proxyAddress, method, status);
        return MapUtils.computeIfAbsent(this.responseTimeCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Timer.builder(name).tags("remote.address", address, "proxy.address", proxyAddress, "uri", uri, "method", method, "status", status).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        String proxyAddr;
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, proxyAddr = Metrics.formatSocketAddress(proxyAddress), null, null);
        DistributionSummary dataReceived = MapUtils.computeIfAbsent(this.dataReceivedCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(DistributionSummary.builder(this.name() + ".data.received").baseUnit(ChannelMeters.DATA_RECEIVED.getBaseUnit()).tags(ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address, ChannelMeters.ChannelMetersTags.PROXY_ADDRESS.asString(), proxyAddr, ChannelMeters.ChannelMetersTags.URI.asString(), uri).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record(bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri, long bytes) {
        String proxyAddr;
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, proxyAddr = Metrics.formatSocketAddress(proxyAddress), null, null);
        DistributionSummary dataSent = MapUtils.computeIfAbsent(this.dataSentCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(DistributionSummary.builder(this.name() + ".data.sent").baseUnit(ChannelMeters.DATA_SENT.getBaseUnit()).tags(ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address, ChannelMeters.ChannelMetersTags.PROXY_ADDRESS.asString(), proxyAddr, ChannelMeters.ChannelMetersTags.URI.asString(), uri).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record(bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, SocketAddress proxyAddress, String uri) {
        String proxyAddr;
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, proxyAddr = Metrics.formatSocketAddress(proxyAddress), null, null);
        Counter errors = MapUtils.computeIfAbsent(this.errorsCache, meterKey, key -> MicrometerHttpClientMetricsRecorder.filter(Counter.builder(this.name() + ".errors").tags(ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address, ChannelMeters.ChannelMetersTags.PROXY_ADDRESS.asString(), proxyAddr, ChannelMeters.ChannelMetersTags.URI.asString(), uri).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }
}

