/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class UndertowWebSocketSession
extends AbstractListenerWebSocketSession<WebSocketChannel> {
    public UndertowWebSocketSession(WebSocketChannel channel, HandshakeInfo info, DataBufferFactory factory) {
        this(channel, info, factory, null);
    }

    public UndertowWebSocketSession(WebSocketChannel channel, HandshakeInfo info, DataBufferFactory factory, @Nullable Sinks.Empty<Void> completionSink) {
        super(channel, ObjectUtils.getIdentityHexString(channel), info, factory, completionSink);
        this.suspendReceiving();
    }

    @Override
    protected boolean canSuspendReceiving() {
        return true;
    }

    @Override
    protected void suspendReceiving() {
        ((WebSocketChannel)this.getDelegate()).suspendReceives();
    }

    @Override
    protected void resumeReceiving() {
        ((WebSocketChannel)this.getDelegate()).resumeReceives();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        DataBuffer dataBuffer = message.getPayload();
        WebSocketChannel channel = (WebSocketChannel)this.getDelegate();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = dataBuffer.toString(StandardCharsets.UTF_8);
            WebSockets.sendText((String)text, (WebSocketChannel)channel, (WebSocketCallback)new SendProcessorCallback(message.getPayload()));
            return true;
        }
        this.getSendProcessor().setReadyToSend(false);
        try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
            block10: while (iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                switch (message.getType()) {
                    case BINARY: {
                        WebSockets.sendBinary((ByteBuffer)byteBuffer, (WebSocketChannel)channel, (WebSocketCallback)new SendProcessorCallback(dataBuffer));
                        continue block10;
                    }
                    case PING: {
                        WebSockets.sendPing((ByteBuffer)byteBuffer, (WebSocketChannel)channel, (WebSocketCallback)new SendProcessorCallback(dataBuffer));
                        continue block10;
                    }
                    case PONG: {
                        WebSockets.sendPong((ByteBuffer)byteBuffer, (WebSocketChannel)channel, (WebSocketCallback)new SendProcessorCallback(dataBuffer));
                        continue block10;
                    }
                }
            }
            return true;
            throw new IllegalArgumentException("Unexpected message type: " + message.getType());
        }
    }

    @Override
    public boolean isOpen() {
        return ((WebSocketChannel)this.getDelegate()).isOpen();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        CloseMessage cm = new CloseMessage(status.getCode(), status.getReason());
        if (!((WebSocketChannel)this.getDelegate()).isCloseFrameSent()) {
            WebSockets.sendClose((CloseMessage)cm, (WebSocketChannel)((WebSocketChannel)this.getDelegate()), null);
        }
        return Mono.empty();
    }

    private final class SendProcessorCallback
    implements WebSocketCallback<Void> {
        private final DataBuffer payload;

        SendProcessorCallback(DataBuffer payload) {
            this.payload = payload;
        }

        public void complete(WebSocketChannel channel, Void context) {
            DataBufferUtils.release(this.payload);
            UndertowWebSocketSession.this.getSendProcessor().setReadyToSend(true);
            UndertowWebSocketSession.this.getSendProcessor().onWritePossible();
        }

        public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
            DataBufferUtils.release(this.payload);
            UndertowWebSocketSession.this.getSendProcessor().cancel();
            UndertowWebSocketSession.this.getSendProcessor().onError(throwable);
        }
    }
}

