/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractWebSocketSession<T>
implements WebSocketSession {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final T delegate;
    private final String id;
    private final HandshakeInfo handshakeInfo;
    private final DataBufferFactory bufferFactory;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final String logPrefix;

    protected AbstractWebSocketSession(T delegate, String id, HandshakeInfo info, DataBufferFactory bufferFactory) {
        Assert.notNull(delegate, "Native session is required");
        Assert.notNull((Object)id, "Session id is required");
        Assert.notNull((Object)info, "HandshakeInfo is required");
        Assert.notNull((Object)bufferFactory, "DataBuffer factory is required");
        this.delegate = delegate;
        this.id = id;
        this.handshakeInfo = info;
        this.bufferFactory = bufferFactory;
        this.logPrefix = AbstractWebSocketSession.initLogPrefix(info, id);
        info.getAttributes().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).forEach(entry -> this.attributes.put((String)entry.getKey(), entry.getValue()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.getLogPrefix() + "Session id \"" + this.getId() + "\" for " + this.getHandshakeInfo().getUri());
        }
    }

    private static String initLogPrefix(HandshakeInfo info, String id) {
        return info.getLogPrefix() != null ? info.getLogPrefix() : "[" + id + "] ";
    }

    protected T getDelegate() {
        return this.delegate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public HandshakeInfo getHandshakeInfo() {
        return this.handshakeInfo;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected String getLogPrefix() {
        return this.logPrefix;
    }

    @Override
    public abstract Flux<WebSocketMessage> receive();

    @Override
    public abstract Mono<Void> send(Publisher<WebSocketMessage> var1);

    @Override
    public WebSocketMessage textMessage(String payload) {
        byte[] bytes = payload.getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = this.bufferFactory().wrap(bytes);
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
    }

    @Override
    public WebSocketMessage binaryMessage(Function<DataBufferFactory, DataBuffer> payloadFactory) {
        DataBuffer payload = payloadFactory.apply(this.bufferFactory());
        return new WebSocketMessage(WebSocketMessage.Type.BINARY, payload);
    }

    @Override
    public WebSocketMessage pingMessage(Function<DataBufferFactory, DataBuffer> payloadFactory) {
        DataBuffer payload = payloadFactory.apply(this.bufferFactory());
        return new WebSocketMessage(WebSocketMessage.Type.PING, payload);
    }

    @Override
    public WebSocketMessage pongMessage(Function<DataBufferFactory, DataBuffer> payloadFactory) {
        DataBuffer payload = payloadFactory.apply(this.bufferFactory());
        return new WebSocketMessage(WebSocketMessage.Type.PONG, payload);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", uri=" + this.getHandshakeInfo().getUri() + "]";
    }
}

