/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelAttributeMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private final boolean useDefaultResolution;

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry, boolean useDefaultResolution) {
        super(adapterRegistry);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return this.checkParameterType(parameter, type -> !BeanUtils.isSimpleProperty(type));
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        Class<?> resolvedType = parameter.getParameterType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(resolvedType);
        Assert.state(adapter == null || !adapter.isMultiValue(), "Multi-value publisher is not supported");
        String name = ModelInitializer.getNameForParameter(parameter);
        Mono<WebExchangeDataBinder> dataBinderMono = this.initDataBinder(name, adapter != null ? parameter.nested() : parameter, context, exchange2).doOnNext(binder -> {
            BindingResult errors = binder.getBindingResult();
            if (errors.hasErrors()) {
                throw new WebExchangeBindException(parameter, errors);
            }
        });
        Sinks.One bindingResultSink = Sinks.unsafe().one();
        Map<String, Object> model = context.getModel().asMap();
        model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResultSink.asMono());
        return dataBinderMono.flatMap(binder -> {
            Object attribute = binder.getTarget();
            Assert.state(attribute != null, "Expected model attribute instance");
            return (!this.bindingDisabled(parameter) ? this.bindRequestParameters((WebExchangeDataBinder)binder, exchange2) : Mono.empty()).doOnError(bindingResultSink::tryEmitError).doOnSuccess(aVoid -> {
                this.validateIfApplicable((WebExchangeDataBinder)binder, parameter, exchange2);
                BindingResult bindingResult = binder.getBindingResult();
                model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResult);
                model.put(name, attribute);
                bindingResultSink.tryEmitValue(bindingResult);
            }).then(Mono.fromCallable(() -> {
                BindingResult errors = binder.getBindingResult();
                if (adapter != null) {
                    Mono<Object> mono = errors.hasErrors() ? Mono.error(new WebExchangeBindException(parameter, errors)) : Mono.just(attribute);
                    return adapter.fromPublisher(mono);
                }
                if (errors.hasErrors() && !this.hasErrorsArgument(parameter)) {
                    throw new WebExchangeBindException(parameter, errors);
                }
                return attribute;
            }));
        });
    }

    private Mono<WebExchangeDataBinder> initDataBinder(String name, MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        Object value = context.getModel().asMap().get(name);
        if (value == null) {
            value = this.removeReactiveAttribute(name, context.getModel());
        }
        ResolvableType type = ResolvableType.forMethodParameter(parameter);
        if (value != null) {
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, value);
            Assert.isTrue(adapter == null || !adapter.isMultiValue(), "Multi-value publisher is not supported");
            return (adapter != null ? Mono.from(adapter.toPublisher(value)) : Mono.just(value)).map(attr -> context.createDataBinder(exchange2, attr, name, type));
        }
        WebExchangeDataBinder binder = context.createDataBinder(exchange2, null, name, type);
        return this.constructAttribute(binder, exchange2).thenReturn(binder);
    }

    @Nullable
    private Object removeReactiveAttribute(String name, Model model) {
        for (Map.Entry<String, Object> entry : model.asMap().entrySet()) {
            ReactiveAdapter adapter;
            if (!entry.getKey().startsWith(name) || (adapter = this.getAdapterRegistry().getAdapter(null, entry.getValue())) == null || !entry.getKey().equals(name + ClassUtils.getShortName(adapter.getReactiveType()))) continue;
            model.asMap().remove(entry.getKey());
            return entry.getValue();
        }
        return null;
    }

    protected Mono<Void> constructAttribute(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder.construct(exchange2);
    }

    private boolean bindingDisabled(MethodParameter parameter) {
        ModelAttribute modelAttribute = parameter.getParameterAnnotation(ModelAttribute.class);
        return modelAttribute != null && !modelAttribute.binding();
    }

    protected Mono<Void> bindRequestParameters(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder.bind(exchange2);
    }

    private boolean hasErrorsArgument(MethodParameter parameter) {
        int i2 = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        return paramTypes.length > i2 + 1 && Errors.class.isAssignableFrom(paramTypes[i2 + 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateIfApplicable(WebExchangeDataBinder binder, MethodParameter parameter, ServerWebExchange exchange2) {
        LocaleContext localeContext = null;
        try {
            for (Annotation ann : parameter.getParameterAnnotations()) {
                Object[] validationHints = ValidationAnnotationUtils.determineValidationHints(ann);
                if (validationHints == null) continue;
                if (localeContext == null) {
                    localeContext = exchange2.getLocaleContext();
                    LocaleContextHolder.setLocaleContext(localeContext);
                }
                binder.validate(validationHints);
            }
        }
        finally {
            if (localeContext != null) {
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }
}

