/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.support;

import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.core.env.Environment;

public final class LoadBalancerEnvironmentPropertyUtils {
    private LoadBalancerEnvironmentPropertyUtils() {
        throw new UnsupportedOperationException("Cannot instantiate a utility class");
    }

    public static boolean trueForClientOrDefault(Environment environment2, String propertySuffix) {
        return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(environment2, propertySuffix, Boolean.TRUE.toString());
    }

    public static boolean equalToForClientOrDefault(Environment environment2, String propertySuffix, String expectedPropertyValue) {
        String defaultValue = LoadBalancerEnvironmentPropertyUtils.getDefaultPropertyValue(environment2, propertySuffix);
        String clientValue = LoadBalancerEnvironmentPropertyUtils.getClientPropertyValue(environment2, propertySuffix);
        if (clientValue != null && clientValue.equalsIgnoreCase(expectedPropertyValue)) {
            return true;
        }
        return clientValue == null && defaultValue != null && defaultValue.equalsIgnoreCase(expectedPropertyValue);
    }

    public static boolean equalToOrMissingForClientOrDefault(Environment environment2, String propertySuffix, String expectedPropertyValue) {
        String defaultValue = LoadBalancerEnvironmentPropertyUtils.getDefaultPropertyValue(environment2, propertySuffix);
        String clientValue = LoadBalancerEnvironmentPropertyUtils.getClientPropertyValue(environment2, propertySuffix);
        if (clientValue != null && clientValue.equalsIgnoreCase(expectedPropertyValue)) {
            return true;
        }
        if (clientValue == null && defaultValue != null && defaultValue.equalsIgnoreCase(expectedPropertyValue)) {
            return true;
        }
        return clientValue == null && defaultValue == null;
    }

    public static boolean trueOrMissingForClientOrDefault(Environment environment2, String propertySuffix) {
        return LoadBalancerEnvironmentPropertyUtils.equalToOrMissingForClientOrDefault(environment2, propertySuffix, Boolean.TRUE.toString());
    }

    private static String getClientPropertyValue(Environment environment2, String propertySuffix) {
        return environment2.getProperty("spring.cloud.loadbalancer.clients." + LoadBalancerClientFactory.getName(environment2) + "." + propertySuffix);
    }

    private static String getDefaultPropertyValue(Environment environment2, String propertySuffix) {
        return environment2.getProperty("spring.cloud.loadbalancer." + propertySuffix);
    }
}

