/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.config.GlobalCorsProperties;
import org.springframework.cloud.gateway.handler.FilteringWebHandler;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RoutePredicateHandlerMapping
extends AbstractHandlerMapping {
    private final FilteringWebHandler webHandler;
    private final RouteLocator routeLocator;
    private final Integer managementPort;
    private final ManagementPortType managementPortType;

    public RoutePredicateHandlerMapping(FilteringWebHandler webHandler, RouteLocator routeLocator, GlobalCorsProperties globalCorsProperties, Environment environment2) {
        this.webHandler = webHandler;
        this.routeLocator = routeLocator;
        this.managementPort = RoutePredicateHandlerMapping.getPortProperty(environment2, "management.server.");
        this.managementPortType = this.getManagementPortType(environment2);
        this.setOrder(environment2.getProperty("spring.cloud.gateway.handler-mapping.order", Integer.class, 1));
        this.setCorsConfigurations(globalCorsProperties.getCorsConfigurations());
    }

    private ManagementPortType getManagementPortType(Environment environment2) {
        Integer serverPort = RoutePredicateHandlerMapping.getPortProperty(environment2, "server.");
        if (this.managementPort != null && this.managementPort < 0) {
            return ManagementPortType.DISABLED;
        }
        return this.managementPort == null || serverPort == null && this.managementPort.equals(8080) || this.managementPort != 0 && this.managementPort.equals(serverPort) ? ManagementPortType.SAME : ManagementPortType.DIFFERENT;
    }

    private static Integer getPortProperty(Environment environment2, String prefix) {
        return environment2.getProperty(prefix + "port", Integer.class);
    }

    @Override
    protected Mono<?> getHandlerInternal(ServerWebExchange exchange2) {
        if (this.managementPortType == ManagementPortType.DIFFERENT && this.managementPort != null && exchange2.getRequest().getLocalAddress() != null && exchange2.getRequest().getLocalAddress().getPort() == this.managementPort.intValue()) {
            return Mono.empty();
        }
        exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_HANDLER_MAPPER_ATTR, this.getSimpleName());
        return Mono.deferContextual(contextView -> {
            exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REACTOR_CONTEXT_ATTR, contextView);
            return this.lookupRoute(exchange2).map(r -> {
                exchange2.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Mapping [" + this.getExchangeDesc(exchange2) + "] to " + r);
                }
                exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, r);
                return this.webHandler;
            }).switchIfEmpty(Mono.empty().then(Mono.fromRunnable(() -> {
                exchange2.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No RouteDefinition found for [" + this.getExchangeDesc(exchange2) + "]");
                }
            })));
        });
    }

    @Override
    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange2) {
        return super.getCorsConfiguration(handler, exchange2);
    }

    private String getExchangeDesc(ServerWebExchange exchange2) {
        StringBuilder out = new StringBuilder();
        out.append("Exchange: ");
        out.append(exchange2.getRequest().getMethod());
        out.append(" ");
        out.append(exchange2.getRequest().getURI());
        return out.toString();
    }

    protected Mono<Route> lookupRoute(ServerWebExchange exchange2) {
        return this.routeLocator.getRoutes().concatMap(route -> Mono.just(route).filterWhen(r -> {
            exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR, r.getId());
            return (Publisher)r.getPredicate().apply(exchange2);
        }).doOnError(e -> this.logger.error("Error applying predicate for route: " + route.getId(), (Throwable)e)).onErrorResume(e -> Mono.empty())).next().map(route -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Route matched: " + route.getId());
            }
            this.validateRoute((Route)route, exchange2);
            return route;
        });
    }

    protected void validateRoute(Route route, ServerWebExchange exchange2) {
    }

    protected String getSimpleName() {
        return "RoutePredicateHandlerMapping";
    }

    public static enum ManagementPortType {
        DISABLED,
        SAME,
        DIFFERENT;

    }
}

