/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayContext;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayDocumentedObservation;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayObservationConvention;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;

public class DefaultGatewayObservationConvention
implements GatewayObservationConvention {
    public static final GatewayObservationConvention INSTANCE = new DefaultGatewayObservationConvention();

    @Override
    public KeyValues getLowCardinalityKeyValues(GatewayContext context) {
        KeyValues keyValues = KeyValues.empty();
        if (context.getCarrier() == null) {
            return keyValues;
        }
        Route route = (Route)context.getServerWebExchange().getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        keyValues = keyValues.and(GatewayDocumentedObservation.LowCardinalityKeys.ROUTE_URI.withValue(route.getUri().toString()), GatewayDocumentedObservation.LowCardinalityKeys.METHOD.withValue(context.getRequest().getMethod().name())).and(GatewayDocumentedObservation.LowCardinalityKeys.ROUTE_ID.withValue(route.getId()));
        ServerHttpResponse response = (ServerHttpResponse)context.getResponse();
        keyValues = response != null && response.getStatusCode() != null ? keyValues.and(GatewayDocumentedObservation.LowCardinalityKeys.STATUS.withValue(String.valueOf(response.getStatusCode().value()))) : keyValues.and(GatewayDocumentedObservation.LowCardinalityKeys.STATUS.withValue("UNKNOWN"));
        return keyValues;
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(GatewayContext context) {
        return KeyValues.of(GatewayDocumentedObservation.HighCardinalityKeys.URI.withValue(context.getRequest().getURI().toString()));
    }

    @Override
    @NonNull
    public String getName() {
        return "http.client.requests";
    }

    @Override
    @Nullable
    public String getContextualName(GatewayContext context) {
        if (context.getRequest() == null) {
            return null;
        }
        return "HTTP " + context.getRequest().getMethod();
    }
}

