/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class GRPCRequestHeadersFilter
implements HttpHeadersFilter,
Ordered {
    @Override
    public HttpHeaders filter(HttpHeaders headers, ServerWebExchange exchange2) {
        HttpHeaders updated = new HttpHeaders();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            updated.addAll(entry.getKey(), entry.getValue());
        }
        if (this.isGRPC(headers.getFirst("Content-Type"))) {
            updated.add("te", "trailers");
        }
        return updated;
    }

    private boolean isGRPC(String contentTypeValue) {
        return StringUtils.startsWithIgnoreCase(contentTypeValue, "application/grpc");
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return HttpHeadersFilter.Type.REQUEST.equals((Object)type);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

