/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Mono;

public class SetPathGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String TEMPLATE_KEY = "template";

    public SetPathGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(TEMPLATE_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        final UriTemplate uriTemplate = new UriTemplate(config.template);
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
                ServerHttpRequest req = exchange2.getRequest();
                ServerWebExchangeUtils.addOriginalRequestUrl(exchange2, req.getURI());
                Map<String, String> uriVariables = ServerWebExchangeUtils.getUriTemplateVariables(exchange2);
                URI uri = uriTemplate.expand(uriVariables);
                String newPath = uri.getRawPath();
                exchange2.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
                ServerHttpRequest request = req.mutate().path(newPath).build();
                return chain.filter(exchange2.mutate().request(request).build());
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(SetPathGatewayFilterFactory.this).append(SetPathGatewayFilterFactory.TEMPLATE_KEY, config.getTemplate()).toString();
            }
        };
    }

    public static class Config {
        private String template;

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }
}

