/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class RemoveJsonAttributesResponseBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<FieldListConfiguration> {
    private final ModifyResponseBodyGatewayFilterFactory modifyResponseBodyGatewayFilterFactory;
    private ObjectMapper mapper = new ObjectMapper();

    public RemoveJsonAttributesResponseBodyGatewayFilterFactory(ModifyResponseBodyGatewayFilterFactory modifyResponseBodyGatewayFilterFactory) {
        this.modifyResponseBodyGatewayFilterFactory = modifyResponseBodyGatewayFilterFactory;
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST_TAIL_FLAG;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("fieldList", "deleteRecursively");
    }

    @Override
    public FieldListConfiguration newConfig() {
        return new FieldListConfiguration();
    }

    @Override
    public Class<FieldListConfiguration> getConfigClass() {
        return FieldListConfiguration.class;
    }

    @Override
    public GatewayFilter apply(FieldListConfiguration config) {
        ModifyResponseBodyGatewayFilterFactory.Config modifyResponseBodyConfig = new ModifyResponseBodyGatewayFilterFactory.Config();
        modifyResponseBodyConfig.setInClass(String.class);
        modifyResponseBodyConfig.setOutClass(String.class);
        RewriteFunction rewriteFunction = (exchange2, body2) -> {
            if (MediaType.APPLICATION_JSON.isCompatibleWith(exchange2.getResponse().getHeaders().getContentType())) {
                try {
                    JsonNode jsonBodyContent = this.mapper.readValue((String)body2, JsonNode.class);
                    this.removeJsonAttribute(jsonBodyContent, config.getFieldList(), config.isDeleteRecursively());
                    body2 = this.mapper.writeValueAsString(jsonBodyContent);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return Mono.just(body2);
        };
        modifyResponseBodyConfig.setRewriteFunction(rewriteFunction);
        return this.modifyResponseBodyGatewayFilterFactory.apply(modifyResponseBodyConfig);
    }

    private void removeJsonAttribute(JsonNode jsonBodyContent, List<String> fieldsToRemove, boolean deleteRecursively) {
        if (deleteRecursively) {
            for (JsonNode jsonNode : jsonBodyContent) {
                if (jsonNode instanceof ObjectNode) {
                    ((ObjectNode)jsonNode).remove(fieldsToRemove);
                    this.removeJsonAttribute(jsonNode, fieldsToRemove, true);
                }
                if (!(jsonNode instanceof ArrayNode)) continue;
                for (JsonNode node : jsonNode) {
                    this.removeJsonAttribute(node, fieldsToRemove, true);
                }
            }
        }
        if (jsonBodyContent instanceof ObjectNode) {
            ((ObjectNode)jsonBodyContent).remove(fieldsToRemove);
        }
    }

    public static class FieldListConfiguration {
        private List<String> fieldList;
        private boolean deleteRecursively;

        public boolean isDeleteRecursively() {
            return this.deleteRecursively;
        }

        public FieldListConfiguration setDeleteRecursively(boolean deleteRecursively) {
            this.deleteRecursively = deleteRecursively;
            return this;
        }

        List<String> getFieldList() {
            return this.fieldList;
        }

        public FieldListConfiguration setFieldList(List<String> fieldList) {
            this.fieldList = fieldList;
            return this;
        }

        public String toString() {
            return new ToStringCreator(this).append("fieldList", this.fieldList).append("deleteRecursively", this.deleteRecursively).toString();
        }
    }
}

