/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.context.ApplicationContext;
import org.springframework.web.reactive.function.client.WebClient;

public class LoadBalancerWebClientBuilderBeanPostProcessor
implements BeanPostProcessor {
    private final DeferringLoadBalancerExchangeFilterFunction exchangeFilterFunction;
    private final ApplicationContext context;

    public LoadBalancerWebClientBuilderBeanPostProcessor(DeferringLoadBalancerExchangeFilterFunction exchangeFilterFunction, ApplicationContext context) {
        this.exchangeFilterFunction = exchangeFilterFunction;
        this.context = context;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof WebClient.Builder) {
            if (this.context.findAnnotationOnBean(beanName, LoadBalanced.class) == null) {
                return bean2;
            }
            ((WebClient.Builder)bean2).filter(this.exchangeFilterFunction);
        }
        return bean2;
    }
}

