/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.reactive.result.view.MustacheViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class MustacheReactiveWebConfiguration {
    MustacheReactiveWebConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.mustache", name={"enabled"}, matchIfMissing=true)
    MustacheViewResolver mustacheViewResolver(Mustache.Compiler mustacheCompiler, MustacheProperties mustache) {
        MustacheViewResolver resolver = new MustacheViewResolver(mustacheCompiler);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(mustache::getPrefix).to(resolver::setPrefix);
        map.from(mustache::getSuffix).to(resolver::setSuffix);
        map.from(mustache::getViewNames).to(resolver::setViewNames);
        map.from(mustache::getRequestContextAttribute).to(resolver::setRequestContextAttribute);
        map.from(mustache::getCharsetName).to(resolver::setCharset);
        map.from(mustache.getReactive()::getMediaTypes).to(resolver::setSupportedMediaTypes);
        resolver.setOrder(0x7FFFFFF5);
        return resolver;
    }
}

