/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import jakarta.validation.Configuration;
import jakarta.validation.Validation;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.NativeDetector;
import org.springframework.core.Ordered;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;

public class BackgroundPreinitializer
implements ApplicationListener<SpringApplicationEvent>,
Ordered {
    public static final String IGNORE_BACKGROUNDPREINITIALIZER_PROPERTY_NAME = "spring.backgroundpreinitializer.ignore";
    private static final AtomicBoolean preinitializationStarted = new AtomicBoolean();
    private static final CountDownLatch preinitializationComplete = new CountDownLatch(1);
    private static final boolean ENABLED = !Boolean.getBoolean("spring.backgroundpreinitializer.ignore") && Runtime.getRuntime().availableProcessors() > 1;

    @Override
    public int getOrder() {
        return -2147483627;
    }

    @Override
    public void onApplicationEvent(SpringApplicationEvent event) {
        if (!ENABLED || NativeDetector.inNativeImage()) {
            return;
        }
        if (event instanceof ApplicationEnvironmentPreparedEvent && preinitializationStarted.compareAndSet(false, true)) {
            this.performPreinitialization();
        }
        if ((event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) && preinitializationStarted.get()) {
            try {
                preinitializationComplete.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void performPreinitialization() {
        try {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.runSafely(new ConversionServiceInitializer());
                    this.runSafely(new ValidationInitializer());
                    if (!this.runSafely(new MessageConverterInitializer())) {
                        this.runSafely(new JacksonInitializer());
                    }
                    this.runSafely(new CharsetInitializer());
                    this.runSafely(new TomcatInitializer());
                    this.runSafely(new JdkInitializer());
                    preinitializationComplete.countDown();
                }

                boolean runSafely(Runnable runnable) {
                    try {
                        runnable.run();
                        return true;
                    }
                    catch (Throwable ex) {
                        return false;
                    }
                }
            }, "background-preinit");
            thread.start();
        }
        catch (Exception ex) {
            preinitializationComplete.countDown();
        }
    }

    private static final class JdkInitializer
    implements Runnable {
        private JdkInitializer() {
        }

        @Override
        public void run() {
            ZoneId.systemDefault();
        }
    }

    private static final class TomcatInitializer
    implements Runnable {
        private TomcatInitializer() {
        }

        @Override
        public void run() {
            new Rfc6265CookieProcessor();
            new NonLoginAuthenticator();
        }
    }

    private static final class CharsetInitializer
    implements Runnable {
        private CharsetInitializer() {
        }

        @Override
        public void run() {
            StandardCharsets.UTF_8.name();
        }
    }

    private static final class ConversionServiceInitializer
    implements Runnable {
        private ConversionServiceInitializer() {
        }

        @Override
        public void run() {
            new DefaultFormattingConversionService();
        }
    }

    private static final class JacksonInitializer
    implements Runnable {
        private JacksonInitializer() {
        }

        @Override
        public void run() {
            Jackson2ObjectMapperBuilder.json().build();
        }
    }

    private static final class ValidationInitializer
    implements Runnable {
        private ValidationInitializer() {
        }

        @Override
        public void run() {
            Configuration<?> configuration = Validation.byDefaultProvider().configure();
            configuration.buildValidatorFactory().getValidator();
        }
    }

    private static final class MessageConverterInitializer
    implements Runnable {
        private MessageConverterInitializer() {
        }

        @Override
        public void run() {
            new AllEncompassingFormHttpMessageConverter();
        }
    }
}

