/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.exchanges;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.actuate.web.exchanges.Include;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpRequest;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpResponse;

public final class HttpExchange {
    private final Instant timestamp;
    private final Request request;
    private final Response response;
    private final Principal principal;
    private final Session session;
    private final Duration timeTaken;

    public HttpExchange(Instant timestamp, Request request, Response response, Principal principal2, Session session, Duration timeTaken) {
        this.timestamp = timestamp;
        this.request = request;
        this.response = response;
        this.principal = principal2;
        this.session = session;
        this.timeTaken = timeTaken;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Session getSession() {
        return this.session;
    }

    public Duration getTimeTaken() {
        return this.timeTaken;
    }

    public static Started start(RecordableHttpRequest request) {
        return HttpExchange.start(Clock.systemUTC(), request);
    }

    public static Started start(Clock clock, RecordableHttpRequest request) {
        return new Started(clock, request);
    }

    public static final class Request {
        private final URI uri;
        private final String remoteAddress;
        private final String method;
        private final Map<String, List<String>> headers;

        private Request(RecordableHttpRequest request, Set<Include> includes) {
            this.uri = request.getUri();
            this.remoteAddress = includes.contains((Object)Include.REMOTE_ADDRESS) ? request.getRemoteAddress() : null;
            this.method = request.getMethod();
            this.headers = Collections.unmodifiableMap(this.filterHeaders(request.getHeaders(), includes));
        }

        public Request(URI uri, String remoteAddress, String method, Map<String, List<String>> headers) {
            this.uri = uri;
            this.remoteAddress = remoteAddress;
            this.method = method;
            this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(headers));
        }

        private Map<String, List<String>> filterHeaders(Map<String, List<String>> headers, Set<Include> includes) {
            HeadersFilter filter2 = new HeadersFilter(includes, Include.REQUEST_HEADERS);
            filter2.excludeUnless("Cookie", Include.COOKIE_HEADERS);
            filter2.excludeUnless("Authorization", Include.AUTHORIZATION_HEADER);
            return filter2.apply(headers);
        }

        public String getMethod() {
            return this.method;
        }

        public URI getUri() {
            return this.uri;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    public static final class Response {
        private final int status;
        private final Map<String, List<String>> headers;

        private Response(RecordableHttpResponse request, Set<Include> includes) {
            this.status = request.getStatus();
            this.headers = Collections.unmodifiableMap(this.filterHeaders(request.getHeaders(), includes));
        }

        public Response(int status, Map<String, List<String>> headers) {
            this.status = status;
            this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(headers));
        }

        private Map<String, List<String>> filterHeaders(Map<String, List<String>> headers, Set<Include> includes) {
            HeadersFilter filter2 = new HeadersFilter(includes, Include.RESPONSE_HEADERS);
            filter2.excludeUnless("Set-Cookie", Include.COOKIE_HEADERS);
            return filter2.apply(headers);
        }

        public int getStatus() {
            return this.status;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }
    }

    public static final class Principal {
        private final String name;

        public Principal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static Principal from(Supplier<java.security.Principal> principalSupplier) {
            java.security.Principal principal2 = principalSupplier.get();
            return principal2 != null ? new Principal(principal2.getName()) : null;
        }
    }

    public static final class Session {
        private final String id;

        public Session(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static Session from(Supplier<String> sessionIdSupplier) {
            String id = sessionIdSupplier.get();
            return id != null ? new Session(id) : null;
        }
    }

    public static final class Started {
        private final Instant timestamp;
        private final RecordableHttpRequest request;

        private Started(Clock clock, RecordableHttpRequest request) {
            this.timestamp = Instant.now(clock);
            this.request = request;
        }

        public HttpExchange finish(RecordableHttpResponse response, Supplier<java.security.Principal> principalSupplier, Supplier<String> sessionIdSupplier, Include ... includes) {
            return this.finish(Clock.systemUTC(), response, principalSupplier, sessionIdSupplier, includes);
        }

        public HttpExchange finish(Clock clock, RecordableHttpResponse response, Supplier<java.security.Principal> principalSupplier, Supplier<String> sessionIdSupplier, Include ... includes) {
            return this.finish(clock, response, principalSupplier, sessionIdSupplier, new HashSet<Include>(Arrays.asList(includes)));
        }

        public HttpExchange finish(RecordableHttpResponse response, Supplier<java.security.Principal> principalSupplier, Supplier<String> sessionIdSupplier, Set<Include> includes) {
            return this.finish(Clock.systemUTC(), response, principalSupplier, sessionIdSupplier, includes);
        }

        public HttpExchange finish(Clock clock, RecordableHttpResponse response, Supplier<java.security.Principal> principalSupplier, Supplier<String> sessionIdSupplier, Set<Include> includes) {
            Request exchangeRequest = new Request(this.request, includes);
            Response exchangeResponse = new Response(response, includes);
            Principal principal2 = this.getIfIncluded(includes, Include.PRINCIPAL, () -> Principal.from(principalSupplier));
            Session session = this.getIfIncluded(includes, Include.SESSION_ID, () -> Session.from(sessionIdSupplier));
            Duration duration = this.getIfIncluded(includes, Include.TIME_TAKEN, () -> Duration.between(this.timestamp, Instant.now(clock)));
            return new HttpExchange(this.timestamp, exchangeRequest, exchangeResponse, principal2, session, duration);
        }

        private <T> T getIfIncluded(Set<Include> includes, Include include, Supplier<T> supplier) {
            return includes.contains((Object)include) ? (T)supplier.get() : null;
        }
    }

    private static class HeadersFilter {
        private final Set<Include> includes;
        private final Include requiredInclude;
        private final Set<String> filteredHeaderNames;

        HeadersFilter(Set<Include> includes, Include requiredInclude) {
            this.includes = includes;
            this.requiredInclude = requiredInclude;
            this.filteredHeaderNames = new HashSet<String>();
        }

        void excludeUnless(String header, Include exception) {
            if (!this.includes.contains((Object)exception)) {
                this.filteredHeaderNames.add(header.toLowerCase());
            }
        }

        Map<String, List<String>> apply(Map<String, List<String>> headers) {
            if (!this.includes.contains((Object)this.requiredInclude)) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, List<String>> filtered = new LinkedHashMap<String, List<String>>();
            headers.forEach((name, value) -> {
                if (!this.filteredHeaderNames.contains(name.toLowerCase())) {
                    filtered.put((String)name, (List<String>)value);
                }
            });
            return filtered;
        }
    }
}

