/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ChildManagementContextInitializer;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

@AutoConfiguration
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={WebEndpointProperties.class, ManagementServerProperties.class})
public class ManagementContextAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    static class DifferentManagementContextConfiguration {
        DifferentManagementContextConfiguration() {
        }

        @Bean
        static ChildManagementContextInitializer childManagementContextInitializer(ManagementContextFactory managementContextFactory, ApplicationContext parentContext) {
            return new ChildManagementContextInitializer(managementContextFactory, parentContext);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnManagementPort(value=ManagementPortType.SAME)
    static class SameManagementContextConfiguration
    implements SmartInitializingSingleton {
        private final Environment environment;

        SameManagementContextConfiguration(Environment environment2) {
            this.environment = environment2;
        }

        @Override
        public void afterSingletonsInstantiated() {
            this.verifySslConfiguration();
            this.verifyAddressConfiguration();
            Environment environment2 = this.environment;
            if (environment2 instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
                this.addLocalManagementPortPropertyAlias(configurableEnvironment);
            }
        }

        private void verifySslConfiguration() {
            Boolean enabled = this.environment.getProperty("management.server.ssl.enabled", Boolean.class, false);
            Assert.state(enabled == false, "Management-specific SSL cannot be configured as the management server is not listening on a separate port");
        }

        private void verifyAddressConfiguration() {
            String address = this.environment.getProperty("management.server.address");
            Assert.state(address == null, "Management-specific server address cannot be configured as the management server is not listening on a separate port");
        }

        private void addLocalManagementPortPropertyAlias(final ConfigurableEnvironment environment2) {
            environment2.getPropertySources().addLast(new PropertySource<Object>("Management Server"){

                @Override
                public Object getProperty(String name) {
                    if ("local.management.port".equals(name)) {
                        return environment2.getProperty("local.server.port");
                    }
                    return null;
                }
            });
        }

        @Configuration(proxyBeanMethods=false)
        @EnableManagementContext(value=ManagementContextType.SAME)
        static class EnableSameManagementContextConfiguration {
            EnableSameManagementContextConfiguration() {
            }
        }
    }
}

