/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationHandlerGrouping;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationRegistryCustomizer;
import org.springframework.boot.util.LambdaSafe;

class ObservationRegistryConfigurer {
    private final ObjectProvider<ObservationRegistryCustomizer<?>> customizers;
    private final ObjectProvider<ObservationPredicate> observationPredicates;
    private final ObjectProvider<GlobalObservationConvention<?>> observationConventions;
    private final ObjectProvider<ObservationHandler<?>> observationHandlers;
    private final ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping;
    private final ObjectProvider<ObservationFilter> observationFilters;

    ObservationRegistryConfigurer(ObjectProvider<ObservationRegistryCustomizer<?>> customizers, ObjectProvider<ObservationPredicate> observationPredicates, ObjectProvider<GlobalObservationConvention<?>> observationConventions, ObjectProvider<ObservationHandler<?>> observationHandlers, ObjectProvider<ObservationHandlerGrouping> observationHandlerGrouping, ObjectProvider<ObservationFilter> observationFilters) {
        this.customizers = customizers;
        this.observationPredicates = observationPredicates;
        this.observationConventions = observationConventions;
        this.observationHandlers = observationHandlers;
        this.observationHandlerGrouping = observationHandlerGrouping;
        this.observationFilters = observationFilters;
    }

    void configure(ObservationRegistry registry) {
        this.registerObservationPredicates(registry);
        this.registerGlobalObservationConventions(registry);
        this.registerHandlers(registry);
        this.registerFilters(registry);
        this.customize(registry);
    }

    private void registerHandlers(ObservationRegistry registry) {
        this.observationHandlerGrouping.ifAvailable(grouping -> grouping.apply(this.asOrderedList(this.observationHandlers), registry.observationConfig()));
    }

    private void registerObservationPredicates(ObservationRegistry registry) {
        this.observationPredicates.orderedStream().forEach(registry.observationConfig()::observationPredicate);
    }

    private void registerGlobalObservationConventions(ObservationRegistry registry) {
        this.observationConventions.orderedStream().forEach(registry.observationConfig()::observationConvention);
    }

    private void registerFilters(ObservationRegistry registry) {
        this.observationFilters.orderedStream().forEach(registry.observationConfig()::observationFilter);
    }

    private void customize(ObservationRegistry registry) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(ObservationRegistryCustomizer.class, this.asOrderedList(this.customizers), registry, new Object[0]).withLogger((Class)ObservationRegistryConfigurer.class)).invoke(customizer2 -> customizer2.customize(registry));
    }

    private <T> List<T> asOrderedList(ObjectProvider<T> provider) {
        return provider.orderedStream().toList();
    }
}

