/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.gm;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Field;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1FieldElement;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Point;
import org.bouncycastle.math.raw.Nat256;
import org.bouncycastle.util.encoders.Hex;

public class SM2P256V1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SM2P256V1FieldElement.Q;
    private static final int SM2P256V1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SM2P256V1_AFFINE_ZS = new ECFieldElement[]{new SM2P256V1FieldElement(ECConstants.ONE)};
    protected SM2P256V1Point infinity = new SM2P256V1Point(this, null, null);

    public SM2P256V1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SM2P256V1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SM2P256V1FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int j = 0; j < n2; ++j) {
            ECPoint eCPoint = eCPointArray[n + j];
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 8);
            n3 += 8;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = 0;
                for (int j = 0; j < n2; ++j) {
                    int n3 = (j ^ n) - 1 >> 31;
                    for (int k = 0; k < 8; ++k) {
                        int n4 = k;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + k] & n3;
                        int n5 = k;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 8 + k] & n3;
                    }
                    n22 += 16;
                }
                return this.createPoint(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = n * 8 * 2;
                for (int j = 0; j < 8; ++j) {
                    nArray3[j] = nArray[n22 + j];
                    nArray2[j] = nArray[n22 + 8 + j];
                }
                return this.createPoint(nArray3, nArray2);
            }

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return SM2P256V1Curve.this.createRawPoint(new SM2P256V1FieldElement(nArray3), new SM2P256V1FieldElement(nArray2), SM2P256V1_AFFINE_ZS);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.random(secureRandom, nArray);
        return new SM2P256V1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        SM2P256V1Field.randomMult(secureRandom, nArray);
        return new SM2P256V1FieldElement(nArray);
    }
}

