/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.apache.commons.math.transform.RealTransformer;
import org.apache.commons.math.util.FastMath;

public class FastSineTransformer
implements RealTransformer {
    public double[] transform(double[] f) throws IllegalArgumentException {
        return this.fst(f);
    }

    public double[] transform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        data[0] = 0.0;
        return this.fst(data);
    }

    public double[] transform2(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = FastMath.sqrt(2.0 / (double)f.length);
        return FastFourierTransformer.scaleArray(this.fst(f), scaling_coefficient);
    }

    public double[] transform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        data[0] = 0.0;
        double scaling_coefficient = FastMath.sqrt(2.0 / (double)n);
        return FastFourierTransformer.scaleArray(this.fst(data), scaling_coefficient);
    }

    public double[] inversetransform(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 2.0 / (double)f.length;
        return FastFourierTransformer.scaleArray(this.fst(f), scaling_coefficient);
    }

    public double[] inversetransform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        data[0] = 0.0;
        double scaling_coefficient = 2.0 / (double)n;
        return FastFourierTransformer.scaleArray(this.fst(data), scaling_coefficient);
    }

    public double[] inversetransform2(double[] f) throws IllegalArgumentException {
        return this.transform2(f);
    }

    public double[] inversetransform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        return this.transform2(f, min, max, n);
    }

    protected double[] fst(double[] f) throws IllegalArgumentException {
        double[] transformed = new double[f.length];
        FastFourierTransformer.verifyDataSet(f);
        if (f[0] != 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FIRST_ELEMENT_NOT_ZERO, f[0]);
        }
        int n = f.length;
        if (n == 1) {
            transformed[0] = 0.0;
            return transformed;
        }
        double[] x = new double[n];
        x[0] = 0.0;
        x[n >> 1] = 2.0 * f[n >> 1];
        for (int i2 = 1; i2 < n >> 1; ++i2) {
            double a = FastMath.sin((double)i2 * Math.PI / (double)n) * (f[i2] + f[n - i2]);
            double b = 0.5 * (f[i2] - f[n - i2]);
            x[i2] = a + b;
            x[n - i2] = a - b;
        }
        FastFourierTransformer transformer = new FastFourierTransformer();
        Complex[] y = transformer.transform(x);
        transformed[0] = 0.0;
        transformed[1] = 0.5 * y[0].getReal();
        for (int i3 = 1; i3 < n >> 1; ++i3) {
            transformed[2 * i3] = -y[i3].getImaginary();
            transformed[2 * i3 + 1] = y[i3].getReal() + transformed[2 * i3 - 1];
        }
        return transformed;
    }
}

