/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.lang.Nullable;
import io.micrometer.jakarta9.instrument.jms.DefaultJmsPublishObservationConvention;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class MessageProducerInvocationHandler
implements InvocationHandler {
    private static final JmsPublishObservationConvention DEFAULT_CONVENTION = new DefaultJmsPublishObservationConvention();
    private final MessageProducer target;
    private final ObservationRegistry registry;

    MessageProducerInvocationHandler(MessageProducer target, ObservationRegistry registry) {
        this.target = target;
        this.registry = registry;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("send".equals(method.getName()) && args[0] != null) {
            Message message = this.findMessageArgument(args);
            Observation observation = JmsObservationDocumentation.JMS_MESSAGE_PUBLISH.observation(null, DEFAULT_CONVENTION, () -> new JmsPublishObservationContext(message), this.registry);
            observation.start();
            try {
                Observation.Scope scope = observation.openScope();
                try {
                    Object object = method.invoke((Object)this.target, args);
                    if (scope != null) {
                        scope.close();
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvocationTargetException exc) {
                        observation.error(exc.getTargetException());
                        throw exc.getTargetException();
                    }
                    catch (Throwable error) {
                        observation.error(error);
                        throw error;
                    }
                }
            }
            finally {
                observation.stop();
            }
        }
        try {
            return method.invoke((Object)this.target, args);
        }
        catch (InvocationTargetException exc) {
            throw exc.getTargetException();
        }
    }

    @Nullable
    private Message findMessageArgument(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof Message)) continue;
            return (Message)arg;
        }
        return null;
    }
}

