/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationConvention;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;

public class DefaultJmsPublishObservationConvention
implements JmsPublishObservationConvention {
    private static final KeyValue DESTINATION_TEMPORARY = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, "true");
    private static final KeyValue DESTINATION_DURABLE = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.DESTINATION_TEMPORARY, "false");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, "none");
    private static final KeyValue OPERATION_PUBLISH = KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.OPERATION, "publish");
    private static final KeyValue MESSAGE_CONVERSATION_ID_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, "unknown");
    private static final KeyValue DESTINATION_NAME_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, "unknown");
    private static final KeyValue MESSAGE_ID_UNKNOWN = KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, "unknown");

    @Override
    public String getName() {
        return "jms.message.publish";
    }

    @Override
    public String getContextualName(JmsPublishObservationContext context) {
        return this.destinationName(context).getValue() + " publish";
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(JmsPublishObservationContext context) {
        return KeyValues.of(this.exception(context), OPERATION_PUBLISH, this.temporaryDestination(context));
    }

    private KeyValue exception(JmsPublishObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of(JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, !simpleName.isEmpty() ? simpleName : error.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue temporaryDestination(JmsPublishObservationContext context) {
        Message message = (Message)context.getCarrier();
        try {
            Destination destination;
            if (message != null && ((destination = message.getJMSDestination()) instanceof TemporaryQueue || destination instanceof TemporaryTopic)) {
                return DESTINATION_TEMPORARY;
            }
            return DESTINATION_DURABLE;
        }
        catch (JMSException exc) {
            return DESTINATION_DURABLE;
        }
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(JmsPublishObservationContext context) {
        return KeyValues.of(this.correlationId(context), this.destinationName(context), this.messageId(context));
    }

    protected KeyValue correlationId(JmsPublishObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            if (message == null || message.getJMSCorrelationID() == null) {
                return MESSAGE_CONVERSATION_ID_UNKNOWN;
            }
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.CONVERSATION_ID, message.getJMSCorrelationID());
        }
        catch (JMSException exc) {
            return MESSAGE_CONVERSATION_ID_UNKNOWN;
        }
    }

    protected KeyValue destinationName(JmsPublishObservationContext context) {
        Message message = (Message)context.getCarrier();
        if (message == null) {
            return DESTINATION_NAME_UNKNOWN;
        }
        try {
            Queue queue;
            String queueName;
            Destination jmsDestination = message.getJMSDestination();
            if (jmsDestination instanceof Queue && (queueName = (queue = (Queue)jmsDestination).getQueueName()) != null) {
                return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, queueName);
            }
            return DefaultJmsPublishObservationConvention.getKeyValueTopic(jmsDestination);
        }
        catch (JMSException e) {
            return DESTINATION_NAME_UNKNOWN;
        }
    }

    private static KeyValue getKeyValueTopic(Destination jmsDestination) throws JMSException {
        Topic topic;
        String topicName;
        if (jmsDestination instanceof Topic && (topicName = (topic = (Topic)jmsDestination).getTopicName()) != null) {
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.DESTINATION_NAME, topicName);
        }
        return DESTINATION_NAME_UNKNOWN;
    }

    protected KeyValue messageId(JmsPublishObservationContext context) {
        try {
            Message message = (Message)context.getCarrier();
            if (message == null || message.getJMSMessageID() == null) {
                return MESSAGE_ID_UNKNOWN;
            }
            return KeyValue.of(JmsObservationDocumentation.HighCardinalityKeyNames.MESSAGE_ID, message.getJMSMessageID());
        }
        catch (JMSException exc) {
            return MESSAGE_ID_UNKNOWN;
        }
    }
}

