/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.observation.Observation;

class ObservationGrpcServerCallListener<RespT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<RespT> {
    private final Observation observation;

    ObservationGrpcServerCallListener(ServerCall.Listener<RespT> delegate, Observation observation) {
        super(delegate);
        this.observation = observation;
    }

    public void onMessage(RespT message) {
        this.observation.event(GrpcObservationDocumentation.GrpcServerEvents.MESSAGE_RECEIVED);
        this.observation.scoped(() -> super.onMessage(message));
    }

    public void onHalfClose() {
        this.observation.scoped(() -> super.onHalfClose());
    }

    public void onCancel() {
        try (Observation.Scope scope = this.observation.openScope();){
            super.onCancel();
        }
        catch (Exception exception) {
            this.observation.error(exception);
            throw exception;
        }
        finally {
            this.observation.stop();
        }
    }

    public void onComplete() {
        try (Observation.Scope scope = this.observation.openScope();){
            super.onComplete();
        }
        catch (Exception exception) {
            this.observation.error(exception);
            throw exception;
        }
        finally {
            this.observation.stop();
        }
    }

    public void onReady() {
        this.observation.scoped(() -> super.onReady());
    }
}

