/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.netflix.infix.ValuePredicate;
import java.util.Map;
import java.util.Set;

public class NumericValuePredicate
implements ValuePredicate<Number> {
    private Number value;
    private Operator op;

    public NumericValuePredicate(Number value, String fnName) {
        Preconditions.checkNotNull(value, "A null number doesn't make sense. ");
        this.value = value;
        this.op = Operator.lookup(fnName);
    }

    public Number getValue() {
        return this.value;
    }

    public String getOpName() {
        return this.op.getOpName();
    }

    @Override
    public boolean apply(Number input) {
        Preconditions.checkNotNull(input, "A null number doesn't make sense.");
        return this.op.compare(input, this.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NumericValuePredicate [value=");
        builder.append(this.value);
        builder.append(", op=");
        builder.append((Object)this.op);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericValuePredicate other = (NumericValuePredicate)obj;
        if (this.op != other.op) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    private static enum Operator {
        GREATER_THAN(">"){

            @Override
            public boolean compare(Number left, Number right) {
                return Operator.doComparison(left, right) > 0;
            }
        }
        ,
        GREATER_THAN_OR_EQUAL(">="){

            @Override
            public boolean compare(Number left, Number right) {
                return Operator.doComparison(left, right) >= 0;
            }
        }
        ,
        LESS_THAN("<"){

            @Override
            public boolean compare(Number left, Number right) {
                return Operator.doComparison(left, right) < 0;
            }
        }
        ,
        LESS_THAN_OR_EQUAL("<="){

            @Override
            public boolean compare(Number left, Number right) {
                return Operator.doComparison(left, right) <= 0;
            }
        }
        ,
        EQUAL("="){

            @Override
            public boolean compare(Number left, Number right) {
                return Operator.doComparison(left, right) == 0;
            }
        }
        ,
        NOT_EQUAL("!="){

            @Override
            public boolean compare(Number left, Number right) {
                return Operator.doComparison(left, right) != 0;
            }
        };

        private String name;
        private static final Map<String, Operator> LOOKUP_TABLE;

        private Operator(String name) {
            this.name = name;
        }

        public String getOpName() {
            return this.name;
        }

        public static Operator lookup(String opName) {
            Operator op = LOOKUP_TABLE.get(opName);
            if (op == null) {
                throw new IllegalArgumentException(String.format("The operator '%s' is not supported. Supported operations: %s", opName, Operator.getOperatorNames()));
            }
            return op;
        }

        public static Set<String> getOperatorNames() {
            return LOOKUP_TABLE.keySet();
        }

        private static int doComparison(Number a, Number b) {
            return Doubles.compare(a.doubleValue(), b.doubleValue());
        }

        public abstract boolean compare(Number var1, Number var2);

        static {
            LOOKUP_TABLE = Maps.newHashMap();
            for (Operator op : Operator.values()) {
                LOOKUP_TABLE.put(op.getOpName(), op);
            }
        }
    }
}

