/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.util.EurekaMonitors;
import com.netflix.eureka.util.ServoControl;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultEurekaServerContext
implements EurekaServerContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEurekaServerContext.class);
    private final EurekaServerConfig serverConfig;
    private final ServerCodecs serverCodecs;
    private final PeerAwareInstanceRegistry registry;
    private final PeerEurekaNodes peerEurekaNodes;
    private final ApplicationInfoManager applicationInfoManager;

    @Inject
    public DefaultEurekaServerContext(EurekaServerConfig serverConfig, ServerCodecs serverCodecs, PeerAwareInstanceRegistry registry, PeerEurekaNodes peerEurekaNodes, ApplicationInfoManager applicationInfoManager) {
        this.serverConfig = serverConfig;
        this.serverCodecs = serverCodecs;
        this.registry = registry;
        this.peerEurekaNodes = peerEurekaNodes;
        this.applicationInfoManager = applicationInfoManager;
    }

    @Override
    @PostConstruct
    public void initialize() {
        logger.info("Initializing ...");
        this.peerEurekaNodes.start();
        try {
            this.registry.init(this.peerEurekaNodes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("Initialized");
    }

    @Override
    @PreDestroy
    public void shutdown() {
        logger.info("Shutting down ...");
        this.registry.shutdown();
        this.peerEurekaNodes.shutdown();
        ServoControl.shutdown();
        EurekaMonitors.shutdown();
        logger.info("Shut down");
    }

    @Override
    public EurekaServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public PeerEurekaNodes getPeerEurekaNodes() {
        return this.peerEurekaNodes;
    }

    @Override
    public ServerCodecs getServerCodecs() {
        return this.serverCodecs;
    }

    @Override
    public PeerAwareInstanceRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }
}

