/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.dns.DnsService;
import com.netflix.discovery.shared.dns.DnsServiceImpl;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.TransportException;
import com.netflix.discovery.shared.transport.TransportUtils;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectingEurekaHttpClient
extends EurekaHttpClientDecorator {
    private static final Logger logger = LoggerFactory.getLogger(RedirectingEurekaHttpClient.class);
    public static final int MAX_FOLLOWED_REDIRECTS = 10;
    private static final Pattern REDIRECT_PATH_REGEX = Pattern.compile("(.*/v2/)apps(/.*)?$");
    private final EurekaEndpoint serviceEndpoint;
    private final TransportClientFactory factory;
    private final DnsService dnsService;
    private final AtomicReference<EurekaHttpClient> delegateRef = new AtomicReference();

    public RedirectingEurekaHttpClient(String serviceUrl, TransportClientFactory factory, DnsService dnsService) {
        this.serviceEndpoint = new DefaultEndpoint(serviceUrl);
        this.factory = factory;
        this.dnsService = dnsService;
    }

    @Override
    public void shutdown() {
        TransportUtils.shutdown(this.delegateRef.getAndSet(null));
    }

    @Override
    protected <R> EurekaHttpResponse<R> execute(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor) {
        EurekaHttpClient currentEurekaClient = this.delegateRef.get();
        if (currentEurekaClient == null) {
            AtomicReference<EurekaHttpClient> currentEurekaClientRef = new AtomicReference<EurekaHttpClient>(this.factory.newClient(this.serviceEndpoint));
            try {
                EurekaHttpResponse<R> response = this.executeOnNewServer(requestExecutor, currentEurekaClientRef);
                TransportUtils.shutdown(this.delegateRef.getAndSet(currentEurekaClientRef.get()));
                return response;
            }
            catch (Exception e) {
                logger.info("Request execution error. endpoint={}, exception={} stacktrace={}", this.serviceEndpoint, e.getMessage(), ExceptionUtils.getStackTrace(e));
                TransportUtils.shutdown(currentEurekaClientRef.get());
                throw e;
            }
        }
        try {
            return requestExecutor.execute(currentEurekaClient);
        }
        catch (Exception e) {
            logger.info("Request execution error. endpoint={} exception={} stacktrace={}", this.serviceEndpoint, e.getMessage(), ExceptionUtils.getStackTrace(e));
            this.delegateRef.compareAndSet(currentEurekaClient, null);
            currentEurekaClient.shutdown();
            throw e;
        }
    }

    public static TransportClientFactory createFactory(final TransportClientFactory delegateFactory) {
        final DnsServiceImpl dnsService = new DnsServiceImpl();
        return new TransportClientFactory(){

            @Override
            public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
                return new RedirectingEurekaHttpClient(endpoint.getServiceUrl(), delegateFactory, dnsService);
            }

            @Override
            public void shutdown() {
                delegateFactory.shutdown();
            }
        };
    }

    private <R> EurekaHttpResponse<R> executeOnNewServer(EurekaHttpClientDecorator.RequestExecutor<R> requestExecutor, AtomicReference<EurekaHttpClient> currentHttpClientRef) {
        URI targetUrl = null;
        for (int followRedirectCount = 0; followRedirectCount < 10; ++followRedirectCount) {
            EurekaHttpResponse<R> httpResponse = requestExecutor.execute(currentHttpClientRef.get());
            if (httpResponse.getStatusCode() != 302) {
                if (followRedirectCount == 0) {
                    logger.debug("Pinning to endpoint {}", (Object)targetUrl);
                } else {
                    logger.info("Pinning to endpoint {}, after {} redirect(s)", (Object)targetUrl, (Object)followRedirectCount);
                }
                return httpResponse;
            }
            targetUrl = this.getRedirectBaseUri(httpResponse.getLocation());
            if (targetUrl == null) {
                throw new TransportException("Invalid redirect URL " + httpResponse.getLocation());
            }
            ((EurekaHttpClient)currentHttpClientRef.getAndSet(null)).shutdown();
            currentHttpClientRef.set(this.factory.newClient(new DefaultEndpoint(targetUrl.toString())));
        }
        String message = "Follow redirect limit crossed for URI " + this.serviceEndpoint.getServiceUrl();
        logger.warn(message);
        throw new TransportException(message);
    }

    private URI getRedirectBaseUri(URI locationURI) {
        if (locationURI == null) {
            throw new TransportException("Missing Location header in the redirect reply");
        }
        Matcher pathMatcher = REDIRECT_PATH_REGEX.matcher(locationURI.getPath());
        if (pathMatcher.matches()) {
            return UriBuilder.fromUri(locationURI).host(this.dnsService.resolveIp(locationURI.getHost())).replacePath(pathMatcher.group(1)).replaceQuery(null).build(new Object[0]);
        }
        logger.warn("Invalid redirect URL {}", (Object)locationURI);
        return null;
    }
}

