/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.discovery.shared.NamedConnectionPool;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

public class MonitoredConnectionManager
extends ThreadSafeClientConnManager {
    public MonitoredConnectionManager(String name) {
        this.initMonitors(name);
    }

    public MonitoredConnectionManager(String name, SchemeRegistry schreg, long connTTL, TimeUnit connTTLTimeUnit) {
        super(schreg, connTTL, connTTLTimeUnit);
        this.initMonitors(name);
    }

    public MonitoredConnectionManager(String name, SchemeRegistry schreg) {
        super(schreg);
        this.initMonitors(name);
    }

    void initMonitors(String name) {
        if (this.pool instanceof NamedConnectionPool) {
            ((NamedConnectionPool)this.pool).initMonitors(name);
        }
    }

    @Override
    @Deprecated
    protected AbstractConnPool createConnectionPool(HttpParams params) {
        return new NamedConnectionPool(this.connOperator, params);
    }

    @Override
    protected ConnPoolByRoute createConnectionPool(long connTTL, TimeUnit connTTLTimeUnit) {
        return new NamedConnectionPool(this.connOperator, this.connPerRoute, 20, connTTL, connTTLTimeUnit);
    }

    @VisibleForTesting
    ConnPoolByRoute getConnectionPool() {
        return this.pool;
    }

    @Override
    public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        return super.requestConnection(route, state);
    }
}

