/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class EnumLookup<T extends Enum<T>> {
    private final int[] sortedHashes;
    private final char[][] sortedNames;
    private final Map<String, T> stringLookup;
    private final T[] sortedValues;
    private final int minLength;
    private final int maxLength;

    EnumLookup(Class<T> enumType) {
        this(enumType, t -> t.name().toCharArray());
    }

    EnumLookup(Class<T> enumType, Function<T, char[]> namer) {
        this.sortedValues = (Enum[])Array.newInstance(enumType, ((Enum[])enumType.getEnumConstants()).length);
        System.arraycopy(enumType.getEnumConstants(), 0, this.sortedValues, 0, this.sortedValues.length);
        Arrays.sort(this.sortedValues, (o1, o2) -> Integer.compare(Arrays.hashCode((char[])namer.apply(o1)), Arrays.hashCode((char[])namer.apply(o2))));
        this.sortedHashes = new int[this.sortedValues.length];
        this.sortedNames = new char[this.sortedValues.length][];
        int i2 = 0;
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        this.stringLookup = new HashMap<String, T>();
        for (T te : this.sortedValues) {
            char[] name = namer.apply(te);
            int hash = Arrays.hashCode(name);
            this.sortedNames[i2] = name;
            this.sortedHashes[i2++] = hash;
            this.stringLookup.put(String.valueOf(name), te);
            maxLength = Math.max(maxLength, name.length);
            minLength = Math.min(minLength, name.length);
        }
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public T find(JsonParser jp) throws IOException {
        return this.find(jp, null);
    }

    public T find(JsonParser jp, T defaultValue) throws IOException {
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            return (T)((Enum)this.stringLookup.getOrDefault(jp.getCurrentName(), defaultValue));
        }
        return this.find(jp.getTextCharacters(), jp.getTextOffset(), jp.getTextLength(), defaultValue);
    }

    public T find(char[] a, int offset, int length) {
        return this.find(a, offset, length, null);
    }

    public T find(char[] a, int offset, int length, T defaultValue) {
        if (length < this.minLength || length > this.maxLength) {
            return defaultValue;
        }
        int hash = EnumLookup.hashCode(a, offset, length);
        int index = Arrays.binarySearch(this.sortedHashes, hash);
        if (index >= 0) {
            for (int i2 = index; i2 < this.sortedValues.length && this.sortedHashes[index] == hash; ++i2) {
                if (!EnumLookup.equals(this.sortedNames[i2], a, offset, length)) continue;
                return this.sortedValues[i2];
            }
        }
        return defaultValue;
    }

    public static boolean equals(char[] a1, char[] a2, int a2Offset, int a2Length) {
        if (a1.length != a2Length) {
            return false;
        }
        for (int i2 = 0; i2 < a2Length; ++i2) {
            if (a1[i2] == a2[i2 + a2Offset]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(char[] a, int offset, int length) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i2 = 0; i2 < length; ++i2) {
            result = 31 * result + a[i2 + offset];
        }
        return result;
    }
}

