/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.reactive;

import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.core.Ordered;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EurekaReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final EurekaClient eurekaClient;
    private final EurekaClientConfig clientConfig;

    public EurekaReactiveDiscoveryClient(EurekaClient eurekaClient, EurekaClientConfig clientConfig) {
        this.eurekaClient = eurekaClient;
        this.clientConfig = clientConfig;
    }

    @Override
    public String description() {
        return "Spring Cloud Eureka Reactive Discovery Client";
    }

    @Override
    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.defer(() -> Flux.fromIterable(this.eurekaClient.getInstancesByVipAddress(serviceId, false))).map(EurekaServiceInstance::new);
    }

    @Override
    public Flux<String> getServices() {
        return Flux.defer(() -> Mono.justOrEmpty(this.eurekaClient.getApplications())).flatMapIterable(Applications::getRegisteredApplications).filter(application -> !application.getInstances().isEmpty()).map(Application::getName).map(String::toLowerCase);
    }

    @Override
    public int getOrder() {
        return this.clientConfig instanceof Ordered ? ((Ordered)((Object)this.clientConfig)).getOrder() : 0;
    }
}

