/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class WebClientEurekaHttpClient
implements EurekaHttpClient {
    private WebClient webClient;

    public WebClientEurekaHttpClient(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("apps/" + info.getAppName(), new Object[0])).body(BodyInserters.fromValue((Object)info)).header("Accept-Encoding", new String[]{"gzip"}).header("Content-Type", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    @Override
    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        return this.webClient.delete().uri("apps/" + appName + "/" + id, new Object[0]).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        String urlPath = "apps/" + appName + "/" + id + "?status=" + info.getStatus().toString() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString() + (String)(overriddenStatus != null ? "&overriddenstatus=" + overriddenStatus.name() : "");
        ResponseEntity response = (ResponseEntity)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri(urlPath, new Object[0])).header("Content-Type", new String[]{"application/json"})).header("Accept", new String[]{"application/json"})).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(InstanceInfo.class).block();
        EurekaHttpResponse.EurekaHttpResponseBuilder<Class<InstanceInfo>> builder = EurekaHttpResponse.anEurekaHttpResponse(this.statusCodeValueOf(response), InstanceInfo.class).headers(WebClientEurekaHttpClient.headersOf(response));
        InstanceInfo entity = (InstanceInfo)response.getBody();
        if (entity != null) {
            builder.entity((Class<InstanceInfo>)((Object)entity));
        }
        return builder.build();
    }

    @Override
    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        String urlPath = "apps/" + appName + "/" + id + "/status?value=" + newStatus.name() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri(urlPath, new Object[0])).header("Content-Type", new String[]{"application/json"})).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    @Override
    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        String urlPath = "apps/" + appName + "/" + id + "/status?lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        return this.webClient.delete().uri(urlPath, new Object[0]).header("Content-Type", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toBodilessEntity().map(this::eurekaHttpResponse).block();
    }

    @Override
    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        Object url = urlPath;
        if (regions != null && regions.length > 0) {
            url = (String)url + (urlPath.contains("?") ? "&" : "?") + "regions=" + StringUtil.join(regions);
        }
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri((String)url, new Object[0]).header("Content-Type", new String[]{"application/json"}).header("Accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(Applications.class).block();
        int statusCode = this.statusCodeValueOf(response);
        Applications body2 = (Applications)response.getBody();
        return EurekaHttpResponse.anEurekaHttpResponse(statusCode, statusCode == HttpStatus.OK.value() && body2 != null ? body2 : null).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    @Override
    public EurekaHttpResponse<Application> getApplication(String appName) {
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri("apps/" + appName, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(Application.class).block();
        int statusCode = this.statusCodeValueOf(response);
        Application body2 = (Application)response.getBody();
        Application application = statusCode == HttpStatus.OK.value() && body2 != null ? body2 : null;
        return EurekaHttpResponse.anEurekaHttpResponse(statusCode, application).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps/" + appName + "/" + id);
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances/" + id);
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri(urlPath, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().onStatus(HttpStatusCode::isError, this::ignoreError).toEntity(InstanceInfo.class).block();
        int statusCode = this.statusCodeValueOf(response);
        InstanceInfo body2 = (InstanceInfo)response.getBody();
        return EurekaHttpResponse.anEurekaHttpResponse(statusCode, statusCode == HttpStatus.OK.value() && body2 != null ? body2 : null).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public void shutdown() {
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    private Mono<? extends Throwable> ignoreError(ClientResponse response) {
        return Mono.empty();
    }

    private static Map<String, String> headersOf(ResponseEntity<?> response) {
        return response.getHeaders().toSingleValueMap();
    }

    private int statusCodeValueOf(ResponseEntity<?> response) {
        return response.getStatusCode().value();
    }

    private EurekaHttpResponse<Void> eurekaHttpResponse(ResponseEntity<?> response) {
        return EurekaHttpResponse.anEurekaHttpResponse(this.statusCodeValueOf(response)).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }
}

