/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;

public class LoadBalancerClientFactory
extends NamedContextFactory<LoadBalancerClientSpecification>
implements ReactiveLoadBalancer.Factory<ServiceInstance> {
    private static final Log log = LogFactory.getLog(LoadBalancerClientFactory.class);
    public static final String NAMESPACE = "loadbalancer";
    public static final String PROPERTY_NAME = "loadbalancer.client.name";
    private final LoadBalancerClientsProperties properties;

    public LoadBalancerClientFactory(LoadBalancerClientsProperties properties) {
        super(LoadBalancerClientConfiguration.class, NAMESPACE, PROPERTY_NAME, new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>());
        this.properties = properties;
    }

    public LoadBalancerClientFactory(LoadBalancerClientsProperties properties, Map<String, ApplicationContextInitializer<GenericApplicationContext>> applicationContextInitializers) {
        super(LoadBalancerClientConfiguration.class, NAMESPACE, PROPERTY_NAME, applicationContextInitializers);
        this.properties = properties;
    }

    public static String getName(Environment environment2) {
        return environment2.getProperty(PROPERTY_NAME);
    }

    @Override
    public ReactiveLoadBalancer<ServiceInstance> getInstance(String serviceId) {
        return this.getInstance(serviceId, ReactorServiceInstanceLoadBalancer.class);
    }

    @Override
    public LoadBalancerProperties getProperties(String serviceId) {
        if (this.properties == null) {
            if (log.isWarnEnabled()) {
                log.warn("LoadBalancerClientsProperties is null. Please use the new constructor.");
            }
            return null;
        }
        if (serviceId == null || !this.properties.getClients().containsKey(serviceId)) {
            return this.properties;
        }
        return this.properties.getClients().get(serviceId);
    }

    public LoadBalancerClientFactory withApplicationContextInitializers(Map<String, Object> applicationContextInitializers) {
        HashMap<String, ApplicationContextInitializer<GenericApplicationContext>> convertedInitializers = new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>();
        applicationContextInitializers.keySet().forEach(contextId -> convertedInitializers.put((String)contextId, (ApplicationContextInitializer)applicationContextInitializers.get(contextId)));
        return new LoadBalancerClientFactory(this.properties, convertedInitializers);
    }
}

