/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.core.style.ToStringCreator;

public class RetryableRequestContext
extends RequestDataContext {
    private ServiceInstance previousServiceInstance;

    public RetryableRequestContext(ServiceInstance previousServiceInstance) {
        this.previousServiceInstance = previousServiceInstance;
    }

    public RetryableRequestContext(ServiceInstance previousServiceInstance, RequestData clientRequestData) {
        super(clientRequestData);
        this.previousServiceInstance = previousServiceInstance;
    }

    public RetryableRequestContext(ServiceInstance previousServiceInstance, RequestData clientRequestData, String hint) {
        super(clientRequestData, hint);
        this.previousServiceInstance = previousServiceInstance;
    }

    public ServiceInstance getPreviousServiceInstance() {
        return this.previousServiceInstance;
    }

    public void setPreviousServiceInstance(ServiceInstance previousServiceInstance) {
        this.previousServiceInstance = previousServiceInstance;
    }

    @Override
    public String toString() {
        ToStringCreator to = new ToStringCreator(this);
        to.append("previousServiceInstance", this.previousServiceInstance);
        return to.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetryableRequestContext)) {
            return false;
        }
        RetryableRequestContext context = (RetryableRequestContext)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.previousServiceInstance, context.previousServiceInstance);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.previousServiceInstance);
    }
}

