/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.regression;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class SimpleRegression
implements Serializable {
    private static final long serialVersionUID = -3004689053607543335L;
    private TDistribution distribution;
    private double sumX = 0.0;
    private double sumXX = 0.0;
    private double sumY = 0.0;
    private double sumYY = 0.0;
    private double sumXY = 0.0;
    private long n = 0L;
    private double xbar = 0.0;
    private double ybar = 0.0;

    public SimpleRegression() {
        this(new TDistributionImpl(1.0));
    }

    @Deprecated
    public SimpleRegression(TDistribution t) {
        this.setDistribution(t);
    }

    public SimpleRegression(int degrees) {
        this.setDistribution(new TDistributionImpl(degrees));
    }

    public void addData(double x, double y) {
        if (this.n == 0L) {
            this.xbar = x;
            this.ybar = y;
        } else {
            double dx = x - this.xbar;
            double dy = y - this.ybar;
            this.sumXX += dx * dx * (double)this.n / ((double)this.n + 1.0);
            this.sumYY += dy * dy * (double)this.n / ((double)this.n + 1.0);
            this.sumXY += dx * dy * (double)this.n / ((double)this.n + 1.0);
            this.xbar += dx / ((double)this.n + 1.0);
            this.ybar += dy / ((double)this.n + 1.0);
        }
        this.sumX += x;
        this.sumY += y;
        ++this.n;
        if (this.n > 2L) {
            this.distribution.setDegreesOfFreedom(this.n - 2L);
        }
    }

    public void removeData(double x, double y) {
        if (this.n > 0L) {
            double dx = x - this.xbar;
            double dy = y - this.ybar;
            this.sumXX -= dx * dx * (double)this.n / ((double)this.n - 1.0);
            this.sumYY -= dy * dy * (double)this.n / ((double)this.n - 1.0);
            this.sumXY -= dx * dy * (double)this.n / ((double)this.n - 1.0);
            this.xbar -= dx / ((double)this.n - 1.0);
            this.ybar -= dy / ((double)this.n - 1.0);
            this.sumX -= x;
            this.sumY -= y;
            --this.n;
            if (this.n > 2L) {
                this.distribution.setDegreesOfFreedom(this.n - 2L);
            }
        }
    }

    public void addData(double[][] data) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            this.addData(data[i2][0], data[i2][1]);
        }
    }

    public void removeData(double[][] data) {
        for (int i2 = 0; i2 < data.length && this.n > 0L; ++i2) {
            this.removeData(data[i2][0], data[i2][1]);
        }
    }

    public void clear() {
        this.sumX = 0.0;
        this.sumXX = 0.0;
        this.sumY = 0.0;
        this.sumYY = 0.0;
        this.sumXY = 0.0;
        this.n = 0L;
    }

    public long getN() {
        return this.n;
    }

    public double predict(double x) {
        double b1 = this.getSlope();
        return this.getIntercept(b1) + b1 * x;
    }

    public double getIntercept() {
        return this.getIntercept(this.getSlope());
    }

    public double getSlope() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        if (FastMath.abs(this.sumXX) < 4.9E-323) {
            return Double.NaN;
        }
        return this.sumXY / this.sumXX;
    }

    public double getSumSquaredErrors() {
        return FastMath.max(0.0, this.sumYY - this.sumXY * this.sumXY / this.sumXX);
    }

    public double getTotalSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumYY;
    }

    public double getXSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumXX;
    }

    public double getSumOfCrossProducts() {
        return this.sumXY;
    }

    public double getRegressionSumSquares() {
        return this.getRegressionSumSquares(this.getSlope());
    }

    public double getMeanSquareError() {
        if (this.n < 3L) {
            return Double.NaN;
        }
        return this.getSumSquaredErrors() / (double)(this.n - 2L);
    }

    public double getR() {
        double b1 = this.getSlope();
        double result = FastMath.sqrt(this.getRSquare());
        if (b1 < 0.0) {
            result = -result;
        }
        return result;
    }

    public double getRSquare() {
        double ssto = this.getTotalSumSquares();
        return (ssto - this.getSumSquaredErrors()) / ssto;
    }

    public double getInterceptStdErr() {
        return FastMath.sqrt(this.getMeanSquareError() * (1.0 / (double)this.n + this.xbar * this.xbar / this.sumXX));
    }

    public double getSlopeStdErr() {
        return FastMath.sqrt(this.getMeanSquareError() / this.sumXX);
    }

    public double getSlopeConfidenceInterval() throws MathException {
        return this.getSlopeConfidenceInterval(0.05);
    }

    public double getSlopeConfidenceInterval(double alpha) throws MathException {
        if (alpha >= 1.0 || alpha <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, alpha, 0.0, 1.0);
        }
        return this.getSlopeStdErr() * this.distribution.inverseCumulativeProbability(1.0 - alpha / 2.0);
    }

    public double getSignificance() throws MathException {
        return 2.0 * (1.0 - this.distribution.cumulativeProbability(FastMath.abs(this.getSlope()) / this.getSlopeStdErr()));
    }

    private double getIntercept(double slope) {
        return (this.sumY - slope * this.sumX) / (double)this.n;
    }

    private double getRegressionSumSquares(double slope) {
        return slope * slope * this.sumXX;
    }

    @Deprecated
    public void setDistribution(TDistribution value) {
        this.distribution = value;
        if (this.n > 2L) {
            this.distribution.setDegreesOfFreedom(this.n - 2L);
        }
    }
}

