/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.fraction.BigFraction;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DefaultFieldMatrixChangingVisitor;
import org.apache.commons.math.linear.FieldDecompositionSolver;
import org.apache.commons.math.linear.FieldLUDecompositionImpl;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math.linear.MatrixUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckTransformer {
    private static final Map<Integer, AdamsNordsieckTransformer> CACHE = new HashMap<Integer, AdamsNordsieckTransformer>();
    private final Array2DRowRealMatrix initialization;
    private final Array2DRowRealMatrix update;
    private final double[] c1;

    private AdamsNordsieckTransformer(int nSteps) {
        FieldMatrix<BigFraction> bigP = this.buildP(nSteps);
        FieldDecompositionSolver<BigFraction> pSolver = new FieldLUDecompositionImpl<BigFraction>(bigP).getSolver();
        Object[] u = new BigFraction[nSteps];
        Arrays.fill(u, BigFraction.ONE);
        BigFraction[] bigC1 = (BigFraction[])pSolver.solve((FieldElement[])u);
        FieldElement[][] shiftedP = (BigFraction[][])bigP.getData();
        for (int i2 = shiftedP.length - 1; i2 > 0; --i2) {
            shiftedP[i2] = shiftedP[i2 - 1];
        }
        shiftedP[0] = new BigFraction[nSteps];
        Arrays.fill(shiftedP[0], BigFraction.ZERO);
        FieldMatrix<BigFraction> bigMSupdate = pSolver.solve(new Array2DRowFieldMatrix(shiftedP, false));
        bigP.walkInOptimizedOrder((FieldMatrixChangingVisitor<BigFraction>)new DefaultFieldMatrixChangingVisitor<BigFraction>(BigFraction.ZERO){

            @Override
            public BigFraction visit(int row, int column, BigFraction value) {
                return (column & 1) == 1 ? value : value.negate();
            }
        });
        FieldMatrix<BigFraction> bigRInverse = new FieldLUDecompositionImpl<BigFraction>(bigP).getSolver().getInverse();
        this.initialization = MatrixUtils.bigFractionMatrixToRealMatrix(bigRInverse);
        this.update = MatrixUtils.bigFractionMatrixToRealMatrix(bigMSupdate);
        this.c1 = new double[nSteps];
        for (int i3 = 0; i3 < nSteps; ++i3) {
            this.c1[i3] = bigC1[i3].doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdamsNordsieckTransformer getInstance(int nSteps) {
        Map<Integer, AdamsNordsieckTransformer> map = CACHE;
        synchronized (map) {
            AdamsNordsieckTransformer t = CACHE.get(nSteps);
            if (t == null) {
                t = new AdamsNordsieckTransformer(nSteps);
                CACHE.put(nSteps, t);
            }
            return t;
        }
    }

    public int getNSteps() {
        return this.c1.length;
    }

    private FieldMatrix<BigFraction> buildP(int nSteps) {
        FieldElement[][] pData = new BigFraction[nSteps][nSteps];
        for (int i2 = 0; i2 < pData.length; ++i2) {
            int factor;
            BigFraction[] pI = pData[i2];
            int aj = factor = -(i2 + 1);
            for (int j = 0; j < pI.length; ++j) {
                pI[j] = new BigFraction(aj * (j + 2));
                aj *= factor;
            }
        }
        return new Array2DRowFieldMatrix(pData, false);
    }

    public Array2DRowRealMatrix initializeHighOrderDerivatives(double[] first, double[][] multistep) {
        for (int i2 = 0; i2 < multistep.length; ++i2) {
            double[] msI = multistep[i2];
            for (int j = 0; j < first.length; ++j) {
                int n = j;
                msI[n] = msI[n] - first[j];
            }
        }
        return this.initialization.multiply(new Array2DRowRealMatrix(multistep, false));
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(double[] start, double[] end, Array2DRowRealMatrix highOrder) {
        double[][] data = highOrder.getDataRef();
        for (int i2 = 0; i2 < data.length; ++i2) {
            double[] dataI = data[i2];
            double c1I = this.c1[i2];
            for (int j = 0; j < dataI.length; ++j) {
                int n = j;
                dataI[n] = dataI[n] + c1I * (start[j] - end[j]);
            }
        }
    }
}

