/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public abstract class AbstractRealMatrix
implements RealMatrix {
    @Deprecated
    private DecompositionSolver lu;

    protected AbstractRealMatrix() {
        this.lu = null;
    }

    protected AbstractRealMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        if (rowDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, rowDimension, 1);
        }
        if (columnDimension <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, columnDimension, 1);
        }
        this.lu = null;
    }

    public abstract RealMatrix createMatrix(int var1, int var2) throws IllegalArgumentException;

    public abstract RealMatrix copy();

    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) + m.getEntry(row, col));
            }
        }
        return out;
    }

    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) - m.getEntry(row, col));
            }
        }
        return out;
    }

    public RealMatrix scalarAdd(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) + d);
            }
        }
        return out;
    }

    public RealMatrix scalarMultiply(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) * d);
            }
        }
        return out;
    }

    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        RealMatrix out = this.createMatrix(nRows, nCols);
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                double sum = 0.0;
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum += this.getEntry(row, i2) * m.getEntry(i2, col);
                }
                out.setEntry(row, col, sum);
            }
        }
        return out;
    }

    public RealMatrix preMultiply(RealMatrix m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    public double[][] getData() {
        double[][] data = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int i2 = 0; i2 < data.length; ++i2) {
            double[] dataI = data[i2];
            for (int j = 0; j < dataI.length; ++j) {
                dataI[j] = this.getEntry(i2, j);
            }
        }
        return data;
    }

    public double getNorm() {
        return this.walkInColumnOrder(new RealMatrixPreservingVisitor(){
            private double endRow;
            private double columnSum;
            private double maxColSum;

            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.endRow = endRow;
                this.columnSum = 0.0;
                this.maxColSum = 0.0;
            }

            public void visit(int row, int column, double value) {
                this.columnSum += FastMath.abs(value);
                if ((double)row == this.endRow) {
                    this.maxColSum = FastMath.max(this.maxColSum, this.columnSum);
                    this.columnSum = 0.0;
                }
            }

            public double end() {
                return this.maxColSum;
            }
        });
    }

    public double getFrobeniusNorm() {
        return this.walkInOptimizedOrder(new RealMatrixPreservingVisitor(){
            private double sum;

            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.sum = 0.0;
            }

            public void visit(int row, int column, double value) {
                this.sum += value * value;
            }

            public double end() {
                return FastMath.sqrt(this.sum);
            }
        });
    }

    public RealMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        RealMatrix subMatrix = this.createMatrix(endRow - startRow + 1, endColumn - startColumn + 1);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            for (int j = startColumn; j <= endColumn; ++j) {
                subMatrix.setEntry(i2 - startRow, j - startColumn, this.getEntry(i2, j));
            }
        }
        return subMatrix;
    }

    public RealMatrix getSubMatrix(final int[] selectedRows, final int[] selectedColumns) throws MatrixIndexException {
        MatrixUtils.checkSubMatrixIndex(this, selectedRows, selectedColumns);
        RealMatrix subMatrix = this.createMatrix(selectedRows.length, selectedColumns.length);
        subMatrix.walkInOptimizedOrder(new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                return AbstractRealMatrix.this.getEntry(selectedRows[row], selectedColumns[column]);
            }
        });
        return subMatrix;
    }

    public void copySubMatrix(int startRow, int endRow, int startColumn, int endColumn, final double[][] destination) throws MatrixIndexException, IllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        int rowsCount = endRow + 1 - startRow;
        int columnsCount = endColumn + 1 - startColumn;
        if (destination.length < rowsCount || destination[0].length < columnsCount) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, destination.length, destination[0].length, rowsCount, columnsCount);
        }
        this.walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){
            private int startRow;
            private int startColumn;

            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.startRow = startRow;
                this.startColumn = startColumn;
            }

            public void visit(int row, int column, double value) {
                destination[row - this.startRow][column - this.startColumn] = value;
            }
        }, startRow, endRow, startColumn, endColumn);
    }

    public void copySubMatrix(int[] selectedRows, int[] selectedColumns, double[][] destination) throws MatrixIndexException, IllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, selectedRows, selectedColumns);
        if (destination.length < selectedRows.length || destination[0].length < selectedColumns.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, destination.length, destination[0].length, selectedRows.length, selectedColumns.length);
        }
        for (int i2 = 0; i2 < selectedRows.length; ++i2) {
            double[] destinationI = destination[i2];
            for (int j = 0; j < selectedColumns.length; ++j) {
                destinationI[j] = this.getEntry(selectedRows[i2], selectedColumns[j]);
            }
        }
    }

    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        for (int r = 1; r < nRows; ++r) {
            if (subMatrix[r].length == nCols) continue;
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[r].length);
        }
        MatrixUtils.checkRowIndex(this, row);
        MatrixUtils.checkColumnIndex(this, column);
        MatrixUtils.checkRowIndex(this, nRows + row - 1);
        MatrixUtils.checkColumnIndex(this, nCols + column - 1);
        for (int i2 = 0; i2 < nRows; ++i2) {
            for (int j = 0; j < nCols; ++j) {
                this.setEntry(row + i2, column + j, subMatrix[i2][j]);
            }
        }
        this.lu = null;
    }

    public RealMatrix getRowMatrix(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        RealMatrix out = this.createMatrix(1, nCols);
        for (int i2 = 0; i2 < nCols; ++i2) {
            out.setEntry(0, i2, this.getEntry(row, i2));
        }
        return out;
    }

    public void setRowMatrix(int row, RealMatrix matrix) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (matrix.getRowDimension() != 1 || matrix.getColumnDimension() != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, matrix.getRowDimension(), matrix.getColumnDimension(), 1, nCols);
        }
        for (int i2 = 0; i2 < nCols; ++i2) {
            this.setEntry(row, i2, matrix.getEntry(0, i2));
        }
    }

    public RealMatrix getColumnMatrix(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        RealMatrix out = this.createMatrix(nRows, 1);
        for (int i2 = 0; i2 < nRows; ++i2) {
            out.setEntry(i2, 0, this.getEntry(i2, column));
        }
        return out;
    }

    public void setColumnMatrix(int column, RealMatrix matrix) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        if (matrix.getRowDimension() != nRows || matrix.getColumnDimension() != 1) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, matrix.getRowDimension(), matrix.getColumnDimension(), nRows, 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            this.setEntry(i2, column, matrix.getEntry(i2, 0));
        }
    }

    public RealVector getRowVector(int row) throws MatrixIndexException {
        return new ArrayRealVector(this.getRow(row), false);
    }

    public void setRowVector(int row, RealVector vector) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (vector.getDimension() != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, 1, vector.getDimension(), 1, nCols);
        }
        for (int i2 = 0; i2 < nCols; ++i2) {
            this.setEntry(row, i2, vector.getEntry(i2));
        }
    }

    public RealVector getColumnVector(int column) throws MatrixIndexException {
        return new ArrayRealVector(this.getColumn(column), false);
    }

    public void setColumnVector(int column, RealVector vector) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        if (vector.getDimension() != nRows) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, vector.getDimension(), 1, nRows, 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            this.setEntry(i2, column, vector.getEntry(i2));
        }
    }

    public double[] getRow(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        double[] out = new double[nCols];
        for (int i2 = 0; i2 < nCols; ++i2) {
            out[i2] = this.getEntry(row, i2);
        }
        return out;
    }

    public void setRow(int row, double[] array) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, 1, array.length, 1, nCols);
        }
        for (int i2 = 0; i2 < nCols; ++i2) {
            this.setEntry(row, i2, array[i2]);
        }
    }

    public double[] getColumn(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        double[] out = new double[nRows];
        for (int i2 = 0; i2 < nRows; ++i2) {
            out[i2] = this.getEntry(i2, column);
        }
        return out;
    }

    public void setColumn(int column, double[] array) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        if (array.length != nRows) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, array.length, 1, nRows, 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            this.setEntry(i2, column, array[i2]);
        }
    }

    public abstract double getEntry(int var1, int var2) throws MatrixIndexException;

    public abstract void setEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public abstract void addToEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public abstract void multiplyEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public RealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        final RealMatrix out = this.createMatrix(nCols, nRows);
        this.walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                out.setEntry(column, row, value);
            }
        });
        return out;
    }

    @Deprecated
    public RealMatrix inverse() throws InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.getInverse();
    }

    @Deprecated
    public double getDeterminant() throws InvalidMatrixException {
        return new LUDecompositionImpl(this, Double.MIN_NORMAL).getDeterminant();
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Deprecated
    public boolean isSingular() {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return !this.lu.isNonSingular();
    }

    public abstract int getRowDimension();

    public abstract int getColumnDimension();

    public double getTrace() throws NonSquareMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(nRows, nCols);
        }
        double trace = 0.0;
        for (int i2 = 0; i2 < nRows; ++i2) {
            trace += this.getEntry(i2, i2);
        }
        return trace;
    }

    public double[] operate(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nCols);
        }
        double[] out = new double[nRows];
        for (int row = 0; row < nRows; ++row) {
            double sum = 0.0;
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum += this.getEntry(row, i2) * v[i2];
            }
            out[row] = sum;
        }
        return out;
    }

    public RealVector operate(RealVector v) throws IllegalArgumentException {
        try {
            return new ArrayRealVector(this.operate(((ArrayRealVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            int nRows = this.getRowDimension();
            int nCols = this.getColumnDimension();
            if (v.getDimension() != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.getDimension(), nCols);
            }
            double[] out = new double[nRows];
            for (int row = 0; row < nRows; ++row) {
                double sum = 0.0;
                for (int i2 = 0; i2 < nCols; ++i2) {
                    sum += this.getEntry(row, i2) * v.getEntry(i2);
                }
                out[row] = sum;
            }
            return new ArrayRealVector(out, false);
        }
    }

    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        double[] out = new double[nCols];
        for (int col = 0; col < nCols; ++col) {
            double sum = 0.0;
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum += this.getEntry(i2, col) * v[i2];
            }
            out[col] = sum;
        }
        return out;
    }

    public RealVector preMultiply(RealVector v) throws IllegalArgumentException {
        try {
            return new ArrayRealVector(this.preMultiply(((ArrayRealVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            int nRows = this.getRowDimension();
            int nCols = this.getColumnDimension();
            if (v.getDimension() != nRows) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.getDimension(), nRows);
            }
            double[] out = new double[nCols];
            for (int col = 0; col < nCols; ++col) {
                double sum = 0.0;
                for (int i2 = 0; i2 < nRows; ++i2) {
                    sum += this.getEntry(i2, col) * v.getEntry(i2);
                }
                out[col] = sum;
            }
            return new ArrayRealVector(out);
        }
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int row = startRow; row <= endRow; ++row) {
            for (int column = startColumn; column <= endColumn; ++column) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int row = startRow; row <= endRow; ++row) {
            for (int column = startColumn; column <= endColumn; ++column) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int column = startColumn; column <= endColumn; ++column) {
            for (int row = startRow; row <= endRow; ++row) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int column = startColumn; column <= endColumn; ++column) {
            for (int row = startRow; row <= endRow; ++row) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    @Deprecated
    public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.solve(b);
    }

    @Deprecated
    public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.solve(b);
    }

    @Deprecated
    public void luDecompose() throws InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
    }

    public String toString() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        StringBuilder res = new StringBuilder();
        String fullClassName = this.getClass().getName();
        String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        res.append(shortClassName).append("{");
        for (int i2 = 0; i2 < nRows; ++i2) {
            if (i2 > 0) {
                res.append(",");
            }
            res.append("{");
            for (int j = 0; j < nCols; ++j) {
                if (j > 0) {
                    res.append(",");
                }
                res.append(this.getEntry(i2, j));
            }
            res.append("}");
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrix)) {
            return false;
        }
        RealMatrix m = (RealMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                if (this.getEntry(row, col) == m.getEntry(row, col)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * MathUtils.hash(this.getEntry(row, col));
            }
        }
        return ret;
    }
}

