/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Arrays;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.JXPathFunctionNotFoundException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.axes.NodeSetContext;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Operation;

public class ExtensionFunction
extends Operation {
    private QName functionName;

    public ExtensionFunction(QName functionName, Expression[] args) {
        super(args);
        this.functionName = functionName;
    }

    public QName getFunctionName() {
        return this.functionName;
    }

    public boolean computeContextDependent() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.functionName);
        buffer.append('(');
        Expression[] args = this.getArguments();
        if (args != null) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i2]);
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public Object computeValue(EvalContext context) {
        Function function;
        Object[] parameters = null;
        if (this.args != null) {
            parameters = new Object[this.args.length];
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                parameters[i2] = this.convert(this.args[i2].compute(context));
            }
        }
        if ((function = context.getRootContext().getFunction(this.functionName, parameters)) == null) {
            throw new JXPathFunctionNotFoundException("No such function: " + this.functionName + Arrays.asList(parameters));
        }
        Object result = function.invoke(context, parameters);
        return result instanceof NodeSet ? new NodeSetContext(context, (NodeSet)result) : result;
    }

    private Object convert(Object object) {
        return object instanceof EvalContext ? ((EvalContext)object).getValue() : object;
    }
}

