/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler,
Contained {
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private final Log log = LogFactory.getLog(CallbackHandlerImpl.class);
    private Container container;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String name = null;
        Principal principal2 = null;
        Subject subject = null;
        String[] groups = null;
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    name = cpc.getName();
                    principal2 = cpc.getPrincipal();
                    subject = cpc.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    groups = gpc.getGroups();
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    if (this.container == null) {
                        this.log.warn(sm.getString("callbackHandlerImpl.containerMissing", callback.getClass().getName()));
                        continue;
                    }
                    if (this.container.getRealm() == null) {
                        this.log.warn(sm.getString("callbackHandlerImpl.realmMissing", callback.getClass().getName(), this.container.getName()));
                        continue;
                    }
                    PasswordValidationCallback pvc = (PasswordValidationCallback)callback;
                    principal2 = this.container.getRealm().authenticate(pvc.getUsername(), String.valueOf(pvc.getPassword()));
                    pvc.setResult(principal2 != null);
                    subject = pvc.getSubject();
                    continue;
                }
                this.log.error(sm.getString("callbackHandlerImpl.jaspicCallbackMissing", callback.getClass().getName()));
            }
            Principal gp = this.getPrincipal(principal2, name, groups);
            if (subject != null && gp != null) {
                subject.getPrivateCredentials().add(gp);
            }
        }
    }

    private Principal getPrincipal(Principal principal2, String name, String[] groups) {
        if (principal2 instanceof GenericPrincipal) {
            return principal2;
        }
        if (name == null && principal2 != null) {
            name = principal2.getName();
        }
        if (name == null) {
            return null;
        }
        List<Object> roles = groups == null || groups.length == 0 ? Collections.emptyList() : Arrays.asList(groups);
        return new GenericPrincipal(name, roles, principal2);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }
}

