/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.util.Preconditions;
import com.netflix.servo.util.UnmodifiableList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollRunnable.class);
    private final MetricPoller poller;
    private final MetricFilter filter;
    private final boolean reset;
    private final List<MetricObserver> observers;

    public PollRunnable(MetricPoller poller, MetricFilter filter2, Collection<MetricObserver> observers) {
        this(poller, filter2, false, observers);
    }

    public PollRunnable(MetricPoller poller, MetricFilter filter2, boolean reset, Collection<MetricObserver> observers) {
        this.poller = Preconditions.checkNotNull(poller, "poller");
        this.filter = Preconditions.checkNotNull(filter2, "poller");
        this.reset = reset;
        this.observers = UnmodifiableList.copyOf(observers);
    }

    public PollRunnable(MetricPoller poller, MetricFilter filter2, MetricObserver ... observers) {
        this(poller, filter2, false, UnmodifiableList.copyOf(observers));
    }

    @Override
    public void run() {
        try {
            List<Metric> metrics = this.poller.poll(this.filter, this.reset);
            for (MetricObserver o : this.observers) {
                try {
                    o.update(metrics);
                }
                catch (Throwable t) {
                    LOGGER.warn("failed to send metrics to " + o.getName(), t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("failed to poll metrics", t);
        }
    }
}

